<?php

// 設定ファイルを読み込み
import('app/config.php');

if (is_file(MAIN_PATH . MAIN_APPLICATION_PATH . 'app/config.local.php')) {
    import('app/config.local.php');
}

// プラグインを読み込み
import('libs/plugins/loader.php');

// コードカバレッジの記録を開始
if (!isset($_GET['_test'])) {
    service('coverage.php');
    service_coverage_start();
}

// ライブラリを読み込み
model();
service();

// トランザクションを開始
db_transaction();

// 既存データ削除
db_query('DELETE FROM ' . DATABASE_PREFIX . 'members;');
db_query('ALTER TABLE ' . DATABASE_PREFIX . 'members AUTO_INCREMENT = 0;');

// 正常データ
$member = array(
    'class_id'  => '1',
    'name'      => '山田太郎',
    'name_kana' => 'ヤマダタロウ',
    'grade'     => '1',
    'birthday'  => '2002-10-04',
    'email'     => 'taro@example.com',
    'tel'       => '090-1234-5678',
    'memo'      => 'テスト。',
    'image_01'  => 'image_01.png',
    'image_02'  => 'image_02.png',
    'public'    => '1',
);

// 正常登録テスト
{
    // テストデータ
    $test_member = $member;

    // 登録
    $warnings = validate_members(normalize_members($test_member));
    if (empty($warnings)) {
        insert_members(array(
            'values' => $test_member,
        ));
    } else {
        debug($warnings);
    }

    // テスト
    $members = select_members(array(
        'select'   => 'class_id, name, name_kana, grade, birthday, email, tel, memo, image_01, image_02, public',
        'order_by' => 'id DESC',
        'limit'    => 10,
    ));

    $inserted_data = array_shift($members);
    $test_data     = array(
        $inserted_data,
    );
    test_array_subset('insert member', $test_data, $test_member);
}

// クラスの必須テスト
{
    // ダミーデータ
    $test_member = $member;
    $test_member['class_id'] = '';

    // 確認
    $warnings = validate_members(normalize_members($test_member));

    // テスト
    test_equals('validate required member class_id', count($warnings), 1);
}

// 名前の必須テスト
{
    // ダミーデータ
    $test_member = $member;
    $test_member['name'] = '';

    // 確認
    $warnings = validate_members(normalize_members($test_member));

    // テスト
    test_equals('validate required member name', count($warnings), 1);
}

// 名前の長さテスト
{
    // ダミーデータ
    $test_member = $member;
    $test_member['name'] = 'あいうえおかきくけこさしすせそたちつてとな';

    // 確認
    $warnings = validate_members(normalize_members($test_member));

    // テスト
    test_equals('validate max_length member name', count($warnings), 1);
}

// 名前（フリガナ）の必須テスト
{
    // ダミーデータ
    $test_member = $member;
    $test_member['name_kana'] = '';

    // 確認
    $warnings = validate_members(normalize_members($test_member));

    // テスト
    test_equals('validate required member name_kana', count($warnings), 1);
}

// 名前（フリガナ）の書式テスト
{
    // ダミーデータ
    $test_member = $member;
    $test_member['name_kana'] = 'あいうえお';

    // 確認
    $warnings = validate_members(normalize_members($test_member));

    // テスト
    test_equals('validate katakana member name_kana', count($warnings), 1);
}

// 名前（フリガナ）の長さテスト
{
    // ダミーデータ
    $test_member = $member;
    $test_member['name_kana'] = 'アイウエオカキクケコサシスセソタチツテトナ';

    // 確認
    $warnings = validate_members(normalize_members($test_member));

    // テスト
    test_equals('validate max_length member name_kana', count($warnings), 1);
}

// 更新テスト
{
    // ダミーデータ
    $test_member = $member;
    $test_member['name']      = '山田花子';
    $test_member['name_kana'] = 'ヤマダハナコ';

    // 更新
    $warnings = validate_members(normalize_members($test_member));
    if (empty($warnings)) {
        update_members(array(
            'set'   => $test_member,
            'where' => array(
                'name = :name',
                array(
                    'name' => '山田太郎',
                ),
            ),
        ));
    } else {
        debug($warnings);
    }

    // テスト
    $members = select_members(array(
        'select'   => 'class_id, name, name_kana, grade, birthday, email, tel, memo, image_01, image_02, public',
        'order_by' => 'id DESC',
        'limit'    => 10,
    ));

    $updated_data = array_pop($members);
    $test_data    = array(
        $updated_data,
    );
    test_array_subset('update members', $test_data, $test_member);
}

// 削除テスト
{
    // 削除
    delete_members(array(
        'where' => array(
            'name = :name',
            array(
                'name' => '山田花子',
            ),
        ),
    ));

    // テスト
    $members = select_members(array(
        'order_by' => 'id DESC',
        'limit'    => 10,
    ));

    test_equals('delete members', count($members), 0);
}

// トランザクションを終了
db_rollback();

// コードカバレッジの記録を終了
if (!isset($_GET['_test'])) {
    $coverages = service_coverage_end();

    service_coverage_output($coverages, array(
        'app/models/members.php',
    ));
}
