<?php

// 設定ファイルを読み込み
import('app/config.php');

if (is_file(MAIN_PATH . MAIN_APPLICATION_PATH . 'app/config.local.php')) {
    import('app/config.local.php');
}

// プラグインを読み込み
import('libs/plugins/loader.php');

// コードカバレッジの記録を開始
if (!isset($_GET['_test'])) {
    service('coverage.php');
    service_coverage_start();
}

// ライブラリを読み込み
model();
service();

// トランザクションを開始
db_transaction();

// 既存データ削除
db_query('DELETE FROM ' . DATABASE_PREFIX . 'categories;');
db_query('ALTER TABLE ' . DATABASE_PREFIX . 'categories AUTO_INCREMENT = 0;');

// 並び順の一括変更テスト
{
    // テストデータ
    $categories = array(
        array(
            'name' => '分類1',
            'sort' => '1',
        ),
        array(
            'name' => '分類2',
            'sort' => '2',
        ),
        array(
            'name' => '分類3',
            'sort' => '3',
        ),
    );

    // 登録
    foreach ($categories as $category) {
        $warnings = validate_categories(normalize_categories($category));
        if (empty($warnings)) {
            insert_categories(array(
                'values' => $category,
            ));
        } else {
            debug($warnings);
        }
    }

    // テスト
    $categories = select_categories(array(
        'select'   => 'sort',
        'order_by' => 'id',
    ));

    test_equals('sort_categories', array_column($categories, 'sort'), array('1', '2', '3'));

    // 並び順を更新
    service_category_sort(array(
        1 => '3',
        2 => '2',
        3 => '1',
    ));

    // テスト
    $categories = select_categories(array(
        'select'   => 'sort',
        'order_by' => 'id',
    ));

    test_equals('sort_categories', array_column($categories, 'sort'), array('3', '2', '1'));
}

// トランザクションを終了
db_rollback();

// コードカバレッジの記録を終了
if (!isset($_GET['_test'])) {
    $coverages = service_coverage_end();

    service_coverage_output($coverages, array(
        'app/services/category.php',
    ));
}
