<?php

// 設定ファイルを読み込み
import('app/config.php');

if (is_file(MAIN_PATH . MAIN_APPLICATION_PATH . 'app/config.local.php')) {
    import('app/config.local.php');
}

// プラグインを読み込み
import('libs/plugins/loader.php');

// コードカバレッジの記録を開始
if (!isset($_GET['_test'])) {
    service('coverage.php');
    service_coverage_start();
}

// ライブラリを読み込み
model();
service();

// トランザクションを開始
db_transaction();

// 既存データ削除
db_query('DELETE FROM ' . DATABASE_PREFIX . 'classes;');
db_query('ALTER TABLE ' . DATABASE_PREFIX . 'classes AUTO_INCREMENT = 0;');

// 並び順の一括変更テスト
{
    // テストデータ
    $classes = array(
        array(
            'code' => 'class1',
            'name' => '教室1',
            'sort' => '1',
        ),
        array(
            'code' => 'class2',
            'name' => '教室2',
            'sort' => '2',
        ),
        array(
            'code' => 'class3',
            'name' => '教室3',
            'sort' => '3',
        ),
    );

    // 登録
    foreach ($classes as $class) {
        $warnings = validate_classes(normalize_classes($class));
        if (empty($warnings)) {
            insert_classes(array(
                'values' => $class,
            ));
        } else {
            debug($warnings);
        }
    }

    // テスト
    $classes = select_classes(array(
        'select'   => 'sort',
        'order_by' => 'id',
    ));

    test_equals('sort_classes', array_column($classes, 'sort'), array('1', '2', '3'));

    // 並び順を更新
    service_class_sort(array(
        1 => '3',
        2 => '2',
        3 => '1',
    ));

    // テスト
    $classes = select_classes(array(
        'select'   => 'sort',
        'order_by' => 'id',
    ));

    test_equals('sort_classes', array_column($classes, 'sort'), array('3', '2', '1'));
}

// トランザクションを終了
db_rollback();

// コードカバレッジの記録を終了
if (!isset($_GET['_test'])) {
    $coverages = service_coverage_end();

    service_coverage_output($coverages, array(
        'app/services/class.php',
    ));
}
