<?php

// 設定ファイルを読み込み
import('app/config.php');

if (is_file(MAIN_PATH . MAIN_APPLICATION_PATH . 'app/config.local.php')) {
    import('app/config.local.php');
}

// プラグインを読み込み
import('libs/plugins/loader.php');

// コードカバレッジの記録を開始
if (!isset($_GET['_test'])) {
    service('coverage.php');
    service_coverage_start();
}

// ライブラリを読み込み
model();
service();

// トランザクションを開始
db_transaction();

// 既存データ削除
db_query('DELETE FROM ' . DATABASE_PREFIX . 'logs;');
db_query('ALTER TABLE ' . DATABASE_PREFIX . 'logs AUTO_INCREMENT = 0;');

// モデル操作ログの記録テスト
{
    // テストデータ
    $log = array(
        'model' => 'users',
        'exec'  => 'insert',
    );

    // 登録
    service_log_record(null, null, $log['model'], $log['exec']);

    // テスト
    $logs = select_logs(array(
        'select'   => 'model, exec',
        'order_by' => 'id DESC',
        'limit'    => 10,
    ));

    $inserted_data = array_shift($logs);
    $test_data     = array(
        $log,
    );
    test_array_subset('record model log', $test_data, $log);
}

// 任意メッセージの記録テスト
{
    // テストデータ
    $log = array(
        'message' => 'メッセージ',
        'detail'  => '詳細',
    );

    // 登録
    service_log_record($log['message'], $log['detail']);

    // テスト
    $logs = select_logs(array(
        'select'   => 'message, detail',
        'order_by' => 'id DESC',
        'limit'    => 10,
    ));

    $inserted_data = array_shift($logs);
    $test_data     = array(
        $log,
    );
    test_array_subset('record message log', $test_data, $log);
}

// トランザクションを終了
db_rollback();

// コードカバレッジの記録を終了
if (!isset($_GET['_test'])) {
    $coverages = service_coverage_end();

    service_coverage_output($coverages, array(
        'app/services/log.php',
    ));
}
