<?php

// 設定ファイルを読み込み
import('app/config.php');

if (is_file(MAIN_PATH . MAIN_APPLICATION_PATH . 'app/config.local.php')) {
    import('app/config.local.php');
}

// プラグインを読み込み
import('libs/plugins/loader.php');

// コードカバレッジの記録を開始
if (!isset($_GET['_test'])) {
    service('coverage.php');
    service_coverage_start();
}

// ライブラリを読み込み
model();
service();

// トランザクションを開始
db_transaction();

// 既存データ削除
db_query('DELETE FROM ' . DATABASE_PREFIX . 'members;');
db_query('ALTER TABLE ' . DATABASE_PREFIX . 'members AUTO_INCREMENT = 0;');
db_query('DELETE FROM ' . DATABASE_PREFIX . 'classes;');
db_query('ALTER TABLE ' . DATABASE_PREFIX . 'classes AUTO_INCREMENT = 0;');
db_query('DELETE FROM ' . DATABASE_PREFIX . 'category_sets;');

// テストデータ
$member = array(
    'class_id'  => '1',
    'name'      => '山田太郎',
    'name_kana' => 'ヤマダタロウ',
    'grade'     => '1',
    'birthday'  => '2002-10-04',
    'email'     => 'taro@example.com',
    'tel'       => '090-1234-5678',
    'memo'      => 'テスト。',
    'image_01'  => 'image_01.png',
    'image_02'  => 'image_02.png',
    'public'    => '1',
);
$class = array(
    'code' => 'class1',
    'name' => '教室1',
    'sort' => '1',
);

$csv  = '"ID","登録日時","更新日時","削除","クラスID","名前","名前（フリガナ）","成績","生年月日","メールアドレス","電話番号","メモ","画像1","画像2","公開","クラス名","分類ID"' . "\n";
$csv .= '"1","' . localdate('Y-m-d H:i:s') . '","' . localdate('Y-m-d H:i:s') . '","","1","山田太郎","ヤマダタロウ","★☆☆☆☆","2002-10-04","taro@example.com","090-1234-5678","テスト。","image_01.png","image_02.png","公開","教室1",""' . "\n";

$temp_file = tempnam(sys_get_temp_dir(), 'test');

// 名簿のエクスポートテスト
{
    // 登録
    $warnings = validate_members(normalize_members($member));
    if (empty($warnings)) {
        insert_members(array(
            'values' => $member,
        ));
    } else {
        debug($warnings);
    }

    $warnings = validate_classes(normalize_classes($class));
    if (empty($warnings)) {
        insert_classes(array(
            'values' => $class,
        ));
    } else {
        debug($warnings);
    }

    // 名簿をエクスポート
    $exported_data = service_member_export();

    // テスト
    test_equals('member export', mb_convert_encoding($exported_data, 'UTF-8', 'SJIS-WIN'), $csv);

    if (file_put_contents($temp_file, $exported_data) === false) {
        error('ファイル ' . $temp_file . ' を保存できません。');
    }
}

// 既存データ削除
db_query('DELETE FROM ' . DATABASE_PREFIX . 'members;');
db_query('ALTER TABLE ' . DATABASE_PREFIX . 'members AUTO_INCREMENT = 0;');
db_query('DELETE FROM ' . DATABASE_PREFIX . 'category_sets;');

// 名簿のインポートテスト
{
    // 名簿をインポート（登録のみ）
    service_member_import($temp_file, 'insert');

    // テスト
    $members = select_members(array(
        'select'   => 'class_id, name, name_kana, grade, birthday, email, tel, memo, image_01, image_02, public',
        'order_by' => 'id DESC',
        'limit'    => 10,
    ));

    test_equals('member import (insert)', $member, $members[0]);

    // 名簿をインポート（更新のみ）
    service_member_import($temp_file, 'update');

    // テスト
    $members = select_members(array(
        'select'   => 'class_id, name, name_kana, grade, birthday, email, tel, memo, image_01, image_02, public',
        'order_by' => 'id DESC',
        'limit'    => 10,
    ));

    test_equals('member import (update)', $member, $members[0]);

    // 名簿をインポート（入れ替え）
    service_member_import($temp_file, 'replace');

    // テスト
    $members = select_members(array(
        'select'   => 'class_id, name, name_kana, grade, birthday, email, tel, memo, image_01, image_02, public',
        'order_by' => 'id DESC',
        'limit'    => 10,
    ));

    test_equals('member import (replace)', $member, $members[0]);

    // 一時ファイルを削除
    unlink($temp_file);
}

// トランザクションを終了
db_rollback();

// コードカバレッジの記録を終了
if (!isset($_GET['_test'])) {
    $coverages = service_coverage_end();

    service_coverage_output($coverages, array(
        'app/services/member.php',
    ));
}
