<?php

// 設定ファイルを読み込み
import('app/config.php');

if (is_file(MAIN_PATH . MAIN_APPLICATION_PATH . 'app/config.local.php')) {
    import('app/config.local.php');
}

// プラグインを読み込み
import('libs/plugins/loader.php');
import('libs/plugins/hash.php');

// コードカバレッジの記録を開始
if (!isset($_GET['_test'])) {
    service('coverage.php');
    service_coverage_start();
}

// ライブラリを読み込み
model();
service();

// トランザクションを開始
db_transaction();

// 既存データ削除
db_query('DELETE FROM ' . DATABASE_PREFIX . 'users;');
db_query('ALTER TABLE ' . DATABASE_PREFIX . 'users AUTO_INCREMENT = 0;');
db_query('DELETE FROM ' . DATABASE_PREFIX . 'profiles;');
db_query('ALTER TABLE ' . DATABASE_PREFIX . 'profiles AUTO_INCREMENT = 0;');
db_query('DELETE FROM ' . DATABASE_PREFIX . 'sessions;');

// ユーザのオートログインテスト
{
    // テストデータ
    $user = array(
        'username'       => 'test',
        'password'       => 'abcd1234',
        'email'          => 'test@example.com',
        'email_verified' => '1',
    );

    // パスワードのソルトを作成
    $password_salt = hash_salt();

    // ユーザを登録
    $resource = insert_users(array(
        'values' => array(
            'username'       => $user['username'],
            'password'       => hash_crypt($user['password'], $password_salt . ':' . $GLOBALS['config']['hash_salt']),
            'password_salt'  => $password_salt,
            'email'          => $user['email'],
            'email_verified' => $user['email_verified'],
        ),
    ));
    if (!$resource) {
        error('データを登録できません。');
    }

    // IDを取得
    $user_id = db_last_insert_id();

    // プロフィールを登録
    $resource = insert_profiles(array(
        'values' => array(
            'user_id' => $user_id,
        ),
    ));
    if (!$resource) {
        error('データを登録できません。');
    }

    // ランダムな文字列を取得
    $session = rand_string();

    // セッションを登録
    $resource = insert_sessions(array(
        'values' => array(
            'id'      => $session,
            'user_id' => $user_id,
            'agent'   => $_SERVER['HTTP_USER_AGENT'],
            'keep'    => 1,
            'expire'  => localdate('Y-m-d H:i:s', time() + $GLOBALS['config']['cookie_expire']),
        ),
    ));
    if (!$resource) {
        error('データを登録できません。');
    }

    // オートログイン成功
    list($session, $user_id) = service_user_autologin($session);

    // テスト
    test_equals('user autologin success session', $session, true);
    test_equals('user autologin success user_id', $user_id, '1');

    // オートログイン失敗
    list($session, $user_id) = service_user_autologin('XXXXX');

    // テスト
    test_not_equals('user autologin failure session', $session, true);
    test_not_equals('user autologin failure user_id', $user_id, '1');

    // Cookieを削除
    cookie_set('auth[session]', null, 0, $GLOBALS['config']['cookie_path'], $GLOBALS['config']['cookie_domain'], $GLOBALS['config']['cookie_secure']);
}

// トランザクションを終了
db_rollback();

// コードカバレッジの記録を終了
if (!isset($_GET['_test'])) {
    $coverages = service_coverage_end();

    service_coverage_output($coverages, array(
        'app/services/user.php',
    ));
}
