<?php

/*********************************************************************

 Functions for Cron

*********************************************************************/

/**
 * Execution of cron
 *
 * @param string $datetime
 * @param string $command
 *
 * @return bool
 */
function cron_exec($datetime, $command, $timestamp = null)
{
    if (cron_check($datetime, $timestamp)) {
        import($command, false);

        return true;
    } else {
        return false;
    }
}

/**
 * Check for cron
 *
 * @param string   $datetime
 * @param int|null $timestamp
 *
 * @return bool
 */
function cron_check($datetime, $timestamp = null)
{
    $fields = preg_split('/\s+/', $datetime);

    if ($timestamp === null) {
        $timestamp = time();
    }

    $status = array('i', 'H', 'd', 'm', 'w');
    $index  = 0;

    $exec = true;
    foreach ($fields as $field) {
        if (preg_match('/^\*\/(\d+)$/', $field, $matches)) {
            if (localdate($status[$index], $timestamp) % $matches[1] !== 0) {
                $exec = false;
            }
        } elseif (!preg_match('/^\*$/', $field)) {
            if (preg_match('/,/', $field)) {
                $parts = explode(',', $field);
            } else {
                $parts = array($field);
            }

            $flag = false;
            foreach ($parts as $part) {
                if (preg_match('/^(\d+)\-(\d+)$/', $part, $matches)) {
                    if (in_array(localdate($status[$index], $timestamp), range($matches[1], $matches[2]))) {
                        $flag = true;
                    }
                } elseif (preg_match('/^\d+$/', $part)) {
                    if ($part == localdate($status[$index], $timestamp)) {
                        $flag = true;
                    }
                }
            }
            if ($flag === false) {
                $exec = false;
            }
        }

        if ($exec === false) {
            break;
        }

        $index++;
    }

    return $exec;
}
