<?php

/**
 * キューに追加
 *
 * @param string $to
 * @param string $subject
 * @param string $message
 * @param array  $headers
 * @param string $parameter
 *
 * @return bool
 */
function service_queue_push($to, $subject, $message, $headers = array(), $parameter = null)
{
    $resource = insert_queues(array(
        'values' => array(
            'mailto'    => $to,
            'subject'   => $subject,
            'message'   => $message,
            'header'    => empty($headers) ? null : json_encode($headers),
            'parameter' => $parameter,
        )
    ));
    if ($resource) {
        return true;
    } else {
        return false;
    }
}

/**
 * キューから送信
 *
 * @param int $limit
 *
 * @return bool
 */
function service_queue_send($limit = 10)
{
    $queues = select_queues(array(
        'where'    => array(
            '(started IS NULL OR started < :started) AND completed IS NULL',
            array(
                'started' => localdate('Y-m-d H:i:s', time() - 60),
            ),
        ),
        'order_by' => 'id',
        'limit'    => intval($limit),
    ));

    foreach ($queues as $queue) {
        $resource = update_queues(array(
            'set'   => array(
                'started' => localdate('Y-m-d H:i:s')
            ),
            'where' => 'id = ' . intval($queue['id'])
        ));
        if (!$resource) {
            return false;
        }

        if (service_mail_send($queue['mailto'], $queue['subject'], $queue['message'], empty($queue['header']) ? null : json_decode($queue['header'], true), $queue['parameter'])) {
            $set = array(
                'completed' => localdate('Y-m-d H:i:s')
            );
        } else {
            $set = array(
                'failed' => $queue['failed'] + 1
            );
        }

        $resource = update_queues(array(
            'set'   => $set,
            'where' => 'id = ' . intval($queue['id'])
        ));
        if (!$resource) {
            return false;
        }
    }

    return true;
}
