<?php

if (auth() === false) {
    return;
}

if (!file_exists(DATABASE_SCAFFOLD_PATH)) {
    error('db: ' . DATABASE_SCAFFOLD_PATH . ' is not found');
}

// 初期値
$app = 'app/';

$models      = $app . 'models/';
$views       = $app . 'views/';
$controllers = $app . 'controllers/';

$header_file = $views . 'header.php';
$footer_file = $views . 'footer.php';

$before_file = $app . 'controllers/before.php';
$after_file  = $app . 'controllers/after.php';
$config_file = $app . 'config.php';

$exclude_prefix = 'levis_';
$primary_key    = 'id';
$created_key    = 'created';
$modified_key   = 'modified';
$deleted_key    = 'deleted';

$primary_keys = array();

$max_view_key = 3;

$validate_text_length = 1000;
$validate_char_length = 20;

$plugin_validator = true;

$test = 'test/';

// テーブル一覧を取得
$resource = db_query(db_sql('table_list'));
$results  = db_result($resource);

if (count($results) === 0) {
    error('db: Table not found');
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['primary_key'])) {
        $primary_key = $_POST['primary_key'];
    }
    if (isset($_POST['created_key'])) {
        $created_key = $_POST['created_key'];
    }
    if (isset($_POST['modified_key'])) {
        $modified_key = $_POST['modified_key'];
    }
    if (isset($_POST['deleted_key'])) {
        $deleted_key = $_POST['deleted_key'];
    }
    if (isset($_POST['plugin_validator'])) {
        $plugin_validator = $_POST['plugin_validator'] ? true : false;
    }

    $scaffold = '';

    // テーブルごとに処理
    foreach ($results as $result) {
        if (DATABASE_TYPE === 'pdo_mysql' || DATABASE_TYPE === 'mysql') {
            $table_comment = $result['Comment'];
        } else {
            $table_comment = null;
        }

        $table = array_shift($result);

        if (regexp_match('^' . DATABASE_PREFIX . $exclude_prefix, $table)) {
            continue;
        }

        // テーブルごとの初期値
        $primary_flag  = false;
        $created_flag  = false;
        $modified_flag = false;
        $deleted_flag  = false;

        $model_file              = $models . $table . '.php';
        $view_index_file         = $views . $table . '/' . MAIN_DEFAULT_WORK . '.php';
        $view_form_file          = $views . $table . '/form.php';
        $controller_index_file   = $controllers . $table . '/' . MAIN_DEFAULT_WORK . '.php';
        $controller_form_file    = $controllers . $table . '/form.php';
        $controller_post_file    = $controllers . $table . '/post.php';
        $controller_delete_file  = $controllers . $table . '/delete.php';
        $test_model_file         = $test . 'model_' . $table . '.php';
        $test_view_file          = $test . 'view_' . $table . '.php';
        $test_controller_file    = $test . 'controller_' . $table . '.php';
        $test_specification_file = $test . $table . '.csv';

        $define_sql = db_sql('table_define', $table);

        $define_resource = db_query($define_sql);
        $define_results  = db_result($define_resource);

        $model_validate = '';
        $model_filter  = '';
        $model_default  = '';

        $view_search = '';
        $view_head   = '';
        $view_data   = '';

        $view_form = '';

        $controller_initialize = '';
        $controller_normalize  = '';
        $controller_insert     = '';
        $controller_update     = '';

        $test_data          = '';
        $test_select_data   = '';
        $test_insert_data   = array();
        $test_update_data   = array();
        $test_validate_data = array();
        $test_list_data     = array();
        $test_search_data   = array();

        // インデント
        $max_show_length = 0;
        $max_length      = 0;
        foreach ($define_results as $define_result) {
            $field = '';
            if (DATABASE_TYPE === 'pdo_mysql' || DATABASE_TYPE === 'mysql') {
                $field = $define_result['Field'];
            } elseif (DATABASE_TYPE === 'pdo_pgsql' || DATABASE_TYPE === 'pgsql') {
                $field = $define_result['column_name'];
            } elseif (DATABASE_TYPE === 'pdo_sqlite' || DATABASE_TYPE === 'pdo_sqlite2' || DATABASE_TYPE === 'sqlite') {
                $field = $define_result['name'];
            }

            if ($field !== $primary_key && $field !== $created_key && $field !== $modified_key && $field !== $deleted_key) {
                $max_show_length = strlen($field) > $max_show_length ? strlen($field) : $max_show_length;
            }
            $max_length = strlen($field) > $max_length ? strlen($field) : $max_length;
        }

        // 列ごとに処理
        $i = 0;
        foreach ($define_results as $define_result) {
            // テーブル定義を取得
            $field = '';
            $null  = false;
            if (DATABASE_TYPE === 'pdo_mysql' || DATABASE_TYPE === 'mysql') {
                $field   = $define_result['Field'];
                $type    = $define_result['Type'];
                $null    = $define_result['Null'] === 'YES' ? true : false;
                $comment = $define_result['Comment'];
            } elseif (DATABASE_TYPE === 'pdo_pgsql' || DATABASE_TYPE === 'pgsql') {
                $field   = $define_result['column_name'];
                $type    = $define_result['data_type'];
                $null    = $define_result['is_nullable'] === 'YES' ? true : false;
                $comment = null;
            } elseif (DATABASE_TYPE === 'pdo_sqlite' || DATABASE_TYPE === 'pdo_sqlite2' || DATABASE_TYPE === 'sqlite') {
                $field   = $define_result['name'];
                $type    = $define_result['type'];
                $null    = $define_result['notnull'] === 0 ? true : false;
                $comment = null;
            }

            if ($field === $primary_key) {
                $primary_flag = true;

                $primary_keys[$table] = true;
            } elseif ($field === $created_key) {
                $created_flag = true;
            } elseif ($field === $modified_key) {
                $modified_flag = true;
            } elseif ($field === $deleted_key) {
                $deleted_flag = true;
            }

            // モデル用の値を作成
            if ($field !== $primary_key && $field !== $created_key && $field !== $modified_key && $field !== $deleted_key) {
                $model_validate .= '    // ' . ($comment ? $comment : $field) . "\n";
                $model_validate .= '    if (isset($queries[\'' . $field . '\'])) {' . "\n";

                if ($plugin_validator === true) {
                    $model_validate .= '        if (!validator_required($queries[\'' . $field . '\'])) {' . "\n";
                } else {
                    $model_validate .= '        if ($queries[\'' . $field . '\'] === \'\') {' . "\n";
                }

                if ($field === $primary_key || !$null) {
                    $model_validate .= '            $messages[\'' . $field . '\'] = \'' . ($comment ? $comment : $field) . 'が入力されていません。\';' . "\n";
                }

                if (regexp_match('(BLOB|TEXT)', $type)) {
                    if ($plugin_validator === true) {
                        $model_validate .= '        } elseif (!validator_max_length($queries[\'' . $field . '\'], ' . $validate_text_length . ')) {' . "\n";
                    } else {
                        $model_validate .= '        } elseif (mb_strlen($queries[\'' . $field . '\'], MAIN_INTERNAL_ENCODING) > ' . $validate_text_length . ') {' . "\n";
                    }
                    $model_validate .= '            $messages[\'' . $field . '\'] = \'' . ($comment ? $comment : $field) . 'は' . $validate_text_length . '文字以内で入力してください。\';' . "\n";
                } elseif (regexp_match('(CHAR)', $type)) {
                    if ($plugin_validator === true) {
                        $model_validate .= '        } elseif (!validator_max_length($queries[\'' . $field . '\'], ' . $validate_char_length . ')) {' . "\n";
                    } else {
                        $model_validate .= '        } elseif (mb_strlen($queries[\'' . $field . '\'], MAIN_INTERNAL_ENCODING) > ' . $validate_char_length . ') {' . "\n";
                    }
                    $model_validate .= '            $messages[\'' . $field . '\'] = \'' . ($comment ? $comment : $field) . 'は' . $validate_char_length . '文字以内で入力してください。\';' . "\n";
                } elseif (regexp_match('(DATETIME)', $type)) {
                    if ($plugin_validator === true) {
                        $model_validate .= '        } elseif (!validator_datetime($queries[\'' . $field . '\'])) {' . "\n";
                        $model_validate .= '            $messages[\'' . $field . '\'] = \'' . ($comment ? $comment : $field) . 'の値が不正です。\';' . "\n";
                    }
                } elseif (regexp_match('(DATE)', $type)) {
                    if ($plugin_validator === true) {
                        $model_validate .= '        } elseif (!validator_date($queries[\'' . $field . '\'])) {' . "\n";
                        $model_validate .= '            $messages[\'' . $field . '\'] = \'' . ($comment ? $comment : $field) . 'の値が不正です。\';' . "\n";
                    }
                } elseif (regexp_match('(TIME)', $type)) {
                    if ($plugin_validator === true) {
                        $model_validate .= '        } elseif (!validator_time($queries[\'' . $field . '\'])) {' . "\n";
                        $model_validate .= '            $messages[\'' . $field . '\'] = \'' . ($comment ? $comment : $field) . 'の値が不正です。\';' . "\n";
                    }
                }

                $model_validate .= '        }' . "\n";
                $model_validate .= '    }' . "\n";
                $model_validate .= "\n";
            }

            $show_length = $max_show_length - strlen($field);
            if ($show_length > 0) {
                $show_space = str_repeat(' ', $show_length);
            } else {
                $show_space = '';
            }

            $length = $max_length - strlen($field);
            if ($length > 0) {
                $space = str_repeat(' ', $length);
            } else {
                $space = '';
            }

            if ($field !== $created_key && $field !== $modified_key && $field !== $deleted_key) {
                $model_filter .= '    // ' . ($comment ? $comment : $field) . 'を取得' . "\n";
                $model_filter .= '    if (isset($queries[\'' . $field . '\'])) {' . "\n";
                $model_filter .= '        if ($queries[\'' . $field . '\'] !== \'\') {' . "\n";

                if (regexp_match('(BLOB|TEXT|CHAR|DATETIME|DATE|TIME)', $type)) {
                    $model_filter .= '            $wheres[] = \'' . $field . ' LIKE \' . db_escape(\'%\' . $queries[\'' . $field . '\'] . \'%\');' . "\n";
                } else {
                    $model_filter .= '            $wheres[] = \'' . $field . ' = \' . db_escape($queries[\'' . $field . '\']);' . "\n";
                }

                $model_filter .= '            $pagers[] = \'' . $field . '=\' . rawurlencode($queries[\'' . $field . '\']);' . "\n";
                $model_filter .= '        }' . "\n";
                $model_filter .= '    }' . "\n";
                $model_filter .= "\n";
            }

            if ($field === $primary_key) {
                $model_default .= '        \'' . $field . '\' ' . $space . '=> null,' . "\n";
            } elseif ($null) {
                $model_default .= '        \'' . $field . '\' ' . $space . '=> null,' . "\n";
            } elseif (regexp_match('(BLOB|TEXT|CHAR)', $type)) {
                $model_default .= '        \'' . $field . '\' ' . $space . '=> \'\',' . "\n";
            } elseif (regexp_match('(DATETIME)', $type)) {
                $model_default .= '        \'' . $field . '\' ' . $space . '=> localdate(\'Y-m-d H:i:s\'),' . "\n";
            } elseif (regexp_match('(DATE)', $type)) {
                $model_default .= '        \'' . $field . '\' ' . $space . '=> localdate(\'Y-m-d\'),' . "\n";
            } elseif (regexp_match('(TIME)', $type)) {
                $model_default .= '        \'' . $field . '\' ' . $space . '=> localdate(\'H:i:s\'),' . "\n";
            } else {
                $model_default .= '        \'' . $field . '\' ' . $space . '=> 0,' . "\n";
            }

            // ビュー用の値を作成
            if ($field !== $created_key && $field !== $modified_key && $field !== $deleted_key) {
                $view_search .= '                    <dt>' . ($comment ? $comment : $field) . '</dt>' . "\n";
                $view_search .= '                        <dd><input type="text" name="' . $field . '" size="30" value="<?php t($_GET[\'' . $field . '\']) ?>" /></dd>' . "\n";

                if ($i <= $max_view_key) {
                    $view_head .= '                    <th>' . ($comment ? $comment : $field) . '</th>' . "\n";
                    $view_data .= '                    <td><?php h($data[\'' . $field . '\']) ?></td>' . "\n";
                }
            }

            if (regexp_match('(BLOB|TEXT)', $type)) {
                $input = '<textarea name="' . $field . '" rows="10" cols="50"><?php t($_view[\'data\'][\'' . $field . '\']) ?></textarea>';
            } elseif (regexp_match('(CHAR)', $type)) {
                $input = '<input type="text" name="' . $field . '" size="40" value="<?php t($_view[\'data\'][\'' . $field . '\']) ?>" />';
            } else {
                $input = '<input type="text" name="' . $field . '" size="20" value="<?php t($_view[\'data\'][\'' . $field . '\']) ?>" />';
            }

            if ($field !== $primary_key && $field !== $created_key && $field !== $modified_key && $field !== $deleted_key) {
                $view_form .= '                    <dt>' . ($comment ? $comment : $field) . ($null ? '' : ' <em>必須</em>') . '</dt>' . "\n";
                $view_form .= '                        <dd>' . $input . '</dd>' . "\n";
            }

            // コントローラ用の値を作成
            if ($field !== $created_key && $field !== $modified_key && $field !== $deleted_key) {
                $controller_initialize .= 'if (!isset($_GET[\'' . $field . '\'])) {' . "\n";
                $controller_initialize .= '    $_GET[\'' . $field . '\'] = null;' . "\n";
                $controller_initialize .= '}' . "\n";

                $controller_normalize .= '            \'' . $field . '\' ' . $show_space . '=> isset($_POST[\'' . $field . '\']) ' . $show_space . '? $_POST[\'' . $field . '\'] ' . $show_space . ': \'\',' . "\n";
            }
            if ($field !== $primary_key && $field !== $created_key && $field !== $modified_key && $field !== $deleted_key) {
                $controller_insert .= '            \'' . $field . '\' ' . $show_space . '=> $_SESSION[\'post\'][\'data\'][\'' . $field . '\'],' . "\n";
                $controller_update .= '            \'' . $field . '\' ' . $show_space . '=> $_SESSION[\'post\'][\'data\'][\'' . $field . '\'],' . "\n";
            }

            // 単体テスト用の値を作成
            if ($field !== $created_key && $field !== $modified_key && $field !== $deleted_key) {
                if ($field === $primary_key) {
                    $test_data .= '            \'' . $field . '\' ' . $show_space . '=> [N],' . "\n";
                } elseif ($null) {
                    $test_data .= '            \'' . $field . '\' ' . $show_space . '=> null,' . "\n";
                } elseif (regexp_match('(BLOB|TEXT|CHAR)', $type)) {
                    $test_data .= '            \'' . $field . '\' ' . $show_space . '=> \'テスト[N]\',' . "\n";
                } elseif (regexp_match('(DATETIME)', $type)) {
                    $test_data .= '            \'' . $field . '\' ' . $show_space . '=> localdate(\'Y-m-d H:i:s\'),' . "\n";
                } elseif (regexp_match('(DATE)', $type)) {
                    $test_data .= '            \'' . $field . '\' ' . $show_space . '=> localdate(\'Y-m-d\'),' . "\n";
                } elseif (regexp_match('(TIME)', $type)) {
                    $test_data .= '            \'' . $field . '\' ' . $show_space . '=> localdate(\'H:i:s\'),' . "\n";
                } else {
                    $test_data .= '            \'' . $field . '\' ' . $show_space . '=> [N],' . "\n";
                }

                if ($test_select_data !== '') {
                    $test_select_data .= ', ';
                }
                $test_select_data .= $field;
            }

            // テスト仕様書用の値を作成
            if ($field !== $primary_key && $field !== $created_key && $field !== $modified_key && $field !== $deleted_key) {
                if (regexp_match('(BLOB|TEXT|CHAR)', $type)) {
                    $test_insert_data[] = ($comment ? $comment : $field) . 'が空欄で表示される';
                } elseif (regexp_match('(DATETIME)', $type)) {
                    if ($null) {
                        $test_insert_data[] = ($comment ? $comment : $field) . 'が空欄で表示される';
                    } else {
                        $test_insert_data[] = ($comment ? $comment : $field) . 'に今日の日時が表示される';
                    }
                } elseif (regexp_match('(DATE)', $type)) {
                    if ($null) {
                        $test_insert_data[] = ($comment ? $comment : $field) . 'が空欄で表示される';
                    } else {
                        $test_insert_data[] = ($comment ? $comment : $field) . 'に今日の年月日が表示される';
                    }
                } elseif (regexp_match('(TIME)', $type)) {
                    if ($null) {
                        $test_insert_data[] = ($comment ? $comment : $field) . 'が空欄で表示される';
                    } else {
                        $test_insert_data[] = ($comment ? $comment : $field) . 'に今日の時間が表示される';
                    }
                }
                $test_update_data[] = '登録した' . ($comment ? $comment : $field) . 'が表示される';

                if ($field === $primary_key || !$null) {
                    $test_validate_data[] = ($comment ? $comment : $field) . 'を空にする';
                }

                if (regexp_match('(BLOB|TEXT)', $type)) {
                    $test_validate_data[] = ($comment ? $comment : $field) . 'に' . ($validate_text_length + 1) . '文字以上入力する';
                } elseif (regexp_match('(CHAR)', $type)) {
                    $test_validate_data[] = ($comment ? $comment : $field) . 'に' . ($validate_char_length + 1) . '文字以上入力する';
                } elseif (regexp_match('(DATETIME)', $type)) {
                    $test_validate_data[] = ($comment ? $comment : $field) . 'に存在しない日時を入力する';
                } elseif (regexp_match('(DATE)', $type)) {
                    $test_validate_data[] = ($comment ? $comment : $field) . 'に存在しない年月日を入力する';
                } elseif (regexp_match('(TIME)', $type)) {
                    $test_validate_data[] = ($comment ? $comment : $field) . 'に存在しない時間を入力する';
                }
            }
            if ($field !== $created_key && $field !== $modified_key && $field !== $deleted_key) {
                $test_search_data[] = $comment ? $comment : $field;

                if ($i <= $max_view_key) {
                    $test_list_data[] = ($field === $primary_key ? '' : '登録した') . ($comment ? $comment : $field) . 'が表示される';
                }
            }

            if ($field !== $created_key && $field !== $modified_key && $field !== $deleted_key) {
                $i++;
            }
        }

        // ビュー用の値を作成
        $view_head .= '                    <th>編集</th>' . "\n";
        $view_data .= '                    <td><a href="<?php t(MAIN_FILE) ?>/' . $table . '/form?' . $primary_key . '=<?php t($data[\'' . $primary_key . '\']) ?>">編集</a></td>' . "\n";

        // 見出し
        $scaffold .= '[' . $table . ']' . "\n";

        // モデルを作成
        $buffer  = '<?php' . "\n";
        $buffer .= "\n";

        if ($plugin_validator === true) {
            $buffer .= 'import(\'libs/plugins/validator.php\');' . "\n";
            $buffer .= "\n";
        }

        if ($deleted_flag === true) {
            $buffer .= '/**' . "\n";
            $buffer .= ' * ' . ($table_comment ? $table_comment : $table) . 'の取得' . "\n";
            $buffer .= ' *' . "\n";
            $buffer .= ' * @param array $queries' . "\n";
            $buffer .= ' * @param array $options' . "\n";
            $buffer .= ' *' . "\n";
            $buffer .= ' * @return array' . "\n";
            $buffer .= ' */' . "\n";
            $buffer .= 'function select_' . $table . '($queries, $options = array())' . "\n";
            $buffer .= '{' . "\n";
            $buffer .= '    $queries = db_placeholder($queries);' . "\n";
            $buffer .= '' . "\n";
            $buffer .= '    // 記事を取得' . "\n";
            $buffer .= '    $queries[\'from\'] = DATABASE_PREFIX . \'' . $table . '\';' . "\n";
            $buffer .= '' . "\n";
            $buffer .= '    // 削除済みデータは取得しない' . "\n";
            $buffer .= '    if (!isset($queries[\'where\'])) {' . "\n";
            $buffer .= '        $queries[\'where\'] = \'TRUE\';' . "\n";
            $buffer .= '    }' . "\n";
            $buffer .= '    $queries[\'where\'] = \'' . $deleted_key . ' IS NULL AND (\' . $queries[\'where\'] . \')\';' . "\n";
            $buffer .= '' . "\n";
            $buffer .= '    // データを取得' . "\n";
            $buffer .= '    return db_select($queries);' . "\n";
            $buffer .= '}' . "\n";
            $buffer .= "\n";
        }

        if ($created_flag === true || $modified_flag === true) {
            $buffer .= '/**' . "\n";
            $buffer .= ' * ' . ($table_comment ? $table_comment : $table) . 'の登録' . "\n";
            $buffer .= ' *' . "\n";
            $buffer .= ' * @param array $queries' . "\n";
            $buffer .= ' * @param array $options' . "\n";
            $buffer .= ' *' . "\n";
            $buffer .= ' * @return resource' . "\n";
            $buffer .= ' */' . "\n";
            $buffer .= 'function insert_' . $table . '($queries, $options = array())' . "\n";
            $buffer .= '{' . "\n";
            $buffer .= '    $queries = db_placeholder($queries);' . "\n";
            $buffer .= '' . "\n";
            $buffer .= '    // 初期値を取得' . "\n";
            $buffer .= '    $defaults = default_' . $table . '();' . "\n";
            $buffer .= '' . "\n";

            if ($created_flag === true) {
                $buffer .= '    if (isset($queries[\'values\'][\'' . $created_key . '\'])) {' . "\n";
                $buffer .= '        if ($queries[\'values\'][\'' . $created_key . '\'] === false) {' . "\n";
                $buffer .= '            unset($queries[\'values\'][\'' . $created_key . '\']);' . "\n";
                $buffer .= '        }' . "\n";
                $buffer .= '    } else {' . "\n";
                $buffer .= '        $queries[\'values\'][\'' . $created_key . '\'] = $defaults[\'' . $created_key . '\'];' . "\n";
                $buffer .= '    }' . "\n";
            }
            if ($modified_flag === true) {
                $buffer .= '    if (isset($queries[\'values\'][\'' . $modified_key . '\'])) {' . "\n";
                $buffer .= '        if ($queries[\'values\'][\'' . $modified_key . '\'] === false) {' . "\n";
                $buffer .= '            unset($queries[\'values\'][\'' . $modified_key . '\']);' . "\n";
                $buffer .= '        }' . "\n";
                $buffer .= '    } else {' . "\n";
                $buffer .= '        $queries[\'values\'][\'' . $modified_key . '\'] = $defaults[\'' . $modified_key . '\'];' . "\n";
                $buffer .= '    }' . "\n";
            }

            $buffer .= '' . "\n";
            $buffer .= '    // データを登録' . "\n";
            $buffer .= '    $queries[\'insert_into\'] = DATABASE_PREFIX . \'' . $table . '\';' . "\n";
            $buffer .= '' . "\n";
            $buffer .= '    return db_insert($queries);' . "\n";
            $buffer .= '}' . "\n";
            $buffer .= "\n";
        }

        if ($modified_flag === true) {
            $buffer .= '/**' . "\n";
            $buffer .= ' * ' . ($table_comment ? $table_comment : $table) . 'の編集' . "\n";
            $buffer .= ' *' . "\n";
            $buffer .= ' * @param array $queries' . "\n";
            $buffer .= ' * @param array $options' . "\n";
            $buffer .= ' *' . "\n";
            $buffer .= ' * @return resource' . "\n";
            $buffer .= ' */' . "\n";
            $buffer .= 'function update_' . $table . '($queries, $options = array())' . "\n";
            $buffer .= '{' . "\n";
            $buffer .= '    $queries = db_placeholder($queries);' . "\n";
            $buffer .= '' . "\n";
            $buffer .= '    // 初期値を取得' . "\n";
            $buffer .= '    $defaults = default_' . $table . '();' . "\n";
            $buffer .= '' . "\n";
            $buffer .= '    if (isset($queries[\'set\'][\'' . $modified_key . '\'])) {' . "\n";
            $buffer .= '        if ($queries[\'set\'][\'' . $modified_key . '\'] === false) {' . "\n";
            $buffer .= '            unset($queries[\'set\'][\'' . $modified_key . '\']);' . "\n";
            $buffer .= '        }' . "\n";
            $buffer .= '    } else {' . "\n";
            $buffer .= '        $queries[\'set\'][\'' . $modified_key . '\'] = $defaults[\'' . $modified_key . '\'];' . "\n";
            $buffer .= '    }' . "\n";
            $buffer .= '' . "\n";
            $buffer .= '    // データを編集' . "\n";
            $buffer .= '    $queries[\'update\'] = DATABASE_PREFIX . \'' . $table . '\';' . "\n";
            $buffer .= '' . "\n";
            $buffer .= '    return db_update($queries);' . "\n";
            $buffer .= '}' . "\n";
            $buffer .= "\n";
        }

        if ($deleted_flag === true) {
            $buffer .= '/**' . "\n";
            $buffer .= ' * ' . ($table_comment ? $table_comment : $table) . 'の削除' . "\n";
            $buffer .= ' *' . "\n";
            $buffer .= ' * @param array $queries' . "\n";
            $buffer .= ' * @param array $options' . "\n";
            $buffer .= ' *' . "\n";
            $buffer .= ' * @return resource' . "\n";
            $buffer .= ' */' . "\n";
            $buffer .= 'function delete_' . $table . '($queries, $options = array())' . "\n";
            $buffer .= '{' . "\n";
            $buffer .= '    $queries = db_placeholder($queries);' . "\n";
            $buffer .= '    $options = array(' . "\n";
            $buffer .= '        \'softdelete\' => isset($options[\'softdelete\']) ? $options[\'softdelete\'] : true,' . "\n";
            $buffer .= '    );' . "\n";
            $buffer .= '' . "\n";
            $buffer .= '    if ($options[\'softdelete\'] === true) {' . "\n";
            $buffer .= '        // データを編集' . "\n";
            $buffer .= '        $resource = db_update(array(' . "\n";
            $buffer .= '            \'update\' => DATABASE_PREFIX . \'' . $table . ' AS ' . $table . '\',' . "\n";
            $buffer .= '            \'set\'    => array(' . "\n";
            $buffer .= '                \'' . $deleted_key . '\' => localdate(\'Y-m-d H:i:s\'),' . "\n";
            $buffer .= '            ),' . "\n";
            $buffer .= '            \'where\'  => isset($queries[\'where\']) ? $queries[\'where\'] : \'\',' . "\n";
            $buffer .= '            \'limit\'  => isset($queries[\'limit\']) ? $queries[\'limit\'] : \'\',' . "\n";
            $buffer .= '        ));' . "\n";
            $buffer .= '        if (!$resource) {' . "\n";
            $buffer .= '            return $resource;' . "\n";
            $buffer .= '        }' . "\n";
            $buffer .= '    } else {' . "\n";
            $buffer .= '        // データを削除' . "\n";
            $buffer .= '        $resource = db_delete(array(' . "\n";
            $buffer .= '            \'delete_from\' => DATABASE_PREFIX . \'' . $table . ' AS ' . $table . '\',' . "\n";
            $buffer .= '            \'where\'       => isset($queries[\'where\']) ? $queries[\'where\'] : \'\',' . "\n";
            $buffer .= '            \'limit\'       => isset($queries[\'limit\']) ? $queries[\'limit\'] : \'\',' . "\n";
            $buffer .= '        ));' . "\n";
            $buffer .= '        if (!$resource) {' . "\n";
            $buffer .= '            return $resource;' . "\n";
            $buffer .= '        }' . "\n";
            $buffer .= '    }' . "\n";
            $buffer .= '' . "\n";
            $buffer .= '    return $resource;' . "\n";
            $buffer .= '}' . "\n";
            $buffer .= "\n";
        }

        $buffer .= '/**' . "\n";
        $buffer .= ' * ' . ($table_comment ? $table_comment : $table) . 'の検証' . "\n";
        $buffer .= ' *' . "\n";
        $buffer .= ' * @param array $queries' . "\n";
        $buffer .= ' * @param array $options' . "\n";
        $buffer .= ' *' . "\n";
        $buffer .= ' * @return array' . "\n";
        $buffer .= ' */' . "\n";
        $buffer .= 'function validate_' . $table . '($queries, $options = array())' . "\n";
        $buffer .= '{' . "\n";
        $buffer .= '    $messages = array();' . "\n";
        $buffer .= '' . "\n";
        $buffer .= $model_validate;
        $buffer .= '    return $messages;' . "\n";
        $buffer .= '}' . "\n";
        $buffer .= "\n";

        $buffer .= '/**' . "\n";
        $buffer .= ' * ' . ($table_comment ? $table_comment : $table) . 'の絞り込み' . "\n";
        $buffer .= ' *' . "\n";
        $buffer .= ' * @param array $queries' . "\n";
        $buffer .= ' * @param array $options' . "\n";
        $buffer .= ' *' . "\n";
        $buffer .= ' * @return array' . "\n";
        $buffer .= ' */' . "\n";
        $buffer .= 'function filter_' . $table . '($queries, $options = array())' . "\n";
        $buffer .= '{' . "\n";
        $buffer .= '    $wheres = array();' . "\n";
        $buffer .= '    $pagers = array();' . "\n";
        $buffer .= '' . "\n";
        $buffer .= $model_filter;
        $buffer .= '    $results = array(' . "\n";
        $buffer .= '        \'where\' => implode(\' AND \', $wheres),' . "\n";
        $buffer .= '        \'pager\' => implode(\'&amp;\', $pagers),' . "\n";
        $buffer .= '    );' . "\n";
        $buffer .= '' . "\n";
        $buffer .= '    return $results;' . "\n";
        $buffer .= '}' . "\n";
        $buffer .= "\n";

        $buffer .= '/**' . "\n";
        $buffer .= ' * ' . ($table_comment ? $table_comment : $table) . 'の初期値' . "\n";
        $buffer .= ' *' . "\n";
        $buffer .= ' * @return array' . "\n";
        $buffer .= ' */' . "\n";
        $buffer .= 'function default_' . $table . '()' . "\n";
        $buffer .= '{' . "\n";
        $buffer .= '    return array(' . "\n";
        $buffer .= $model_default;
        $buffer .= '    );' . "\n";
        $buffer .= '}' . "\n";

        $scaffold .= db_scaffold_output($model_file, $buffer);

        // ビューを作成
        if ($primary_flag == true) {
            $buffer  = '<?php import(\'app/views/header.php\') ?>' . "\n";
            $buffer .= "\n";
            $buffer .= '        <h2>' . ($table_comment ? $table_comment : $table) . '</h2>' . "\n";
            $buffer .= "\n";
            $buffer .= '        <ul>' . "\n";
            $buffer .= '            <li><a href="<?php t(MAIN_FILE) ?>/' . $table . '/form">' . ($table_comment ? $table_comment : $table) . '登録</a></li>' . "\n";
            $buffer .= '        </ul>' . "\n";
            $buffer .= '        <?php if (isset($_GET[\'ok\'])) : ?>' . "\n";
            $buffer .= '        <ul class="ok">' . "\n";
            $buffer .= '            <?php if ($_GET[\'ok\'] === \'post\') : ?>' . "\n";
            $buffer .= '            <li>データを登録しました。</li>' . "\n";
            $buffer .= '            <?php elseif ($_GET[\'ok\'] === \'delete\') : ?>' . "\n";
            $buffer .= '            <li>データを削除しました。</li>' . "\n";
            $buffer .= '            <?php endif ?>' . "\n";
            $buffer .= '        </ul>' . "\n";
            $buffer .= '        <?php endif ?>' . "\n";
            $buffer .= "\n";
            $buffer .= '        <form action="<?php t(MAIN_FILE) ?>/' . $table . '" method="get">' . "\n";
            $buffer .= '            <fieldset>' . "\n";
            $buffer .= '                <legend>検索フォーム</legend>' . "\n";
            $buffer .= '                <dl>' . "\n";
            $buffer .= $view_search;
            $buffer .= '                </dl>' . "\n";
            $buffer .= '                <p><input type="submit" value="検索する" /></p>' . "\n";
            $buffer .= '            </fieldset>' . "\n";
            $buffer .= '        </form>' . "\n";
            $buffer .= "\n";
            $buffer .= '        <table summary="' . ($table_comment ? $table_comment : $table) . '一覧">' . "\n";
            $buffer .= '            <thead>' . "\n";
            $buffer .= '                <tr>' . "\n";
            $buffer .= $view_head;
            $buffer .= '                </tr>' . "\n";
            $buffer .= '            </thead>' . "\n";
            $buffer .= '            <tfoot>' . "\n";
            $buffer .= '                <tr>' . "\n";
            $buffer .= $view_head;
            $buffer .= '                </tr>' . "\n";
            $buffer .= '            </tfoot>' . "\n";
            $buffer .= '            <tbody>' . "\n";
            $buffer .= '                <?php foreach ($_view[\'' . $table . '\'] as $data) : ?>' . "\n";
            $buffer .= '                <tr>' . "\n";
            $buffer .= $view_data;
            $buffer .= '                </tr>' . "\n";
            $buffer .= '                <?php endforeach ?>' . "\n";
            $buffer .= '            </tbody>' . "\n";
            $buffer .= '        </table>' . "\n";
            $buffer .= "\n";
            $buffer .= '        <?php if ($_view[\'' . $table . '_page\'] > 1) : ?>' . "\n";
            $buffer .= '            <h3>ページ移動</h3>' . "\n";
            $buffer .= '            <p><?php e($_view[\'' . $table . '_pager\']) ?></p>' . "\n";
            $buffer .= '        <?php endif ?>' . "\n";
            $buffer .= "\n";
            $buffer .= '<?php import(\'app/views/footer.php\') ?>' . "\n";

            $scaffold .= db_scaffold_output($view_index_file, $buffer);

            $buffer  = '<?php import(\'app/views/header.php\') ?>' . "\n";
            $buffer .= "\n";
            $buffer .= '        <h2>' . ($table_comment ? $table_comment : $table) . '</h2>' . "\n";
            $buffer .= '' . "\n";
            $buffer .= '        <?php if (isset($_view[\'warnings\'])) : ?>' . "\n";
            $buffer .= '        <ul class="warning">' . "\n";
            $buffer .= '            <?php foreach ($_view[\'warnings\'] as $warning) : ?>' . "\n";
            $buffer .= '            <li><?php h($warning) ?></li>' . "\n";
            $buffer .= '            <?php endforeach ?>' . "\n";
            $buffer .= '        </ul>' . "\n";
            $buffer .= '        <?php endif ?>' . "\n";
            $buffer .= '' . "\n";
            $buffer .= '        <form action="<?php t(MAIN_FILE) ?>/' . $table . '/form<?php $_view[\'data\'][\'' . $primary_key . '\'] ? t(\'?' . $primary_key . '=\' . $_view[\'data\'][\'' . $primary_key . '\']) : \'\' ?>" method="post">' . "\n";
            $buffer .= '            <fieldset>' . "\n";
            $buffer .= '                <legend>登録フォーム</legend>' . "\n";
            $buffer .= '                <input type="hidden" name="_token" value="<?php t($_view[\'token\']) ?>" />' . "\n";
            $buffer .= '                <input type="hidden" name="' . $primary_key . '" value="<?php t($_view[\'data\'][\'' . $primary_key . '\']) ?>" />' . "\n";
            $buffer .= '                <dl>' . "\n";
            $buffer .= $view_form;
            $buffer .= '                </dl>' . "\n";
            $buffer .= '                <p><input type="submit" value="登録する" /></p>' . "\n";
            $buffer .= '            </fieldset>' . "\n";
            $buffer .= '        </form>' . "\n";
            $buffer .= '' . "\n";
            $buffer .= '        <?php if (!empty($_GET[\'' . $primary_key . '\'])) : ?>' . "\n";
            $buffer .= '        <h3>記事削除</h3>' . "\n";
            $buffer .= '        <form action="<?php t(MAIN_FILE) ?>/' . $table . '/delete" method="post">' . "\n";
            $buffer .= '            <fieldset>' . "\n";
            $buffer .= '                <legend>削除フォーム</legend>' . "\n";
            $buffer .= '                <input type="hidden" name="_token" value="<?php t($_view[\'token\']) ?>" />' . "\n";
            $buffer .= '                <input type="hidden" name="' . $primary_key . '" value="<?php t($_view[\'data\'][\'' . $primary_key . '\']) ?>" />' . "\n";
            $buffer .= '                <p><input type="submit" value="削除する" /></p>' . "\n";
            $buffer .= '            </fieldset>' . "\n";
            $buffer .= '        </form>' . "\n";
            $buffer .= '        <?php endif ?>' . "\n";
            $buffer .= "\n";
            $buffer .= '<?php import(\'app/views/footer.php\') ?>' . "\n";

            $scaffold .= db_scaffold_output($view_form_file, $buffer);
        }

        // コントローラを作成
        if ($primary_flag == true) {
            $buffer  = '<?php' . "\n";
            $buffer .= "\n";
            $buffer .= 'import(\'libs/plugins/ui.php\');' . "\n";
            $buffer .= "\n";
            $buffer .= '// 絞り込み' . "\n";
            $buffer .= '$filters = filter_' . $table . '($_GET);' . "\n";
            $buffer .= "\n";
            $buffer .= '// 検索用文字列を初期化' . "\n";
            $buffer .= $controller_initialize;
            $buffer .= "\n";
            $buffer .= '// ページを取得' . "\n";
            $buffer .= 'if (isset($_GET[\'page\'])) {' . "\n";
            $buffer .= '    $_GET[\'page\'] = intval($_GET[\'page\']);' . "\n";
            $buffer .= '} else {' . "\n";
            $buffer .= '    $_GET[\'page\'] = 1;' . "\n";
            $buffer .= '}' . "\n";
            $buffer .= "\n";
            $buffer .= '// ' . ($table_comment ? $table_comment : $table) . 'を取得' . "\n";
            $buffer .= '$_view[\'' . $table . '\'] = select_' . $table . '(array(' . "\n";
            $buffer .= '    \'where\'    => $filters[\'where\'] ? $filters[\'where\'] : null,' . "\n";
            $buffer .= '    \'order_by\' => \'' . $primary_key . ' DESC\',' . "\n";
            $buffer .= '    \'limit\'    => array(' . "\n";
            $buffer .= '        \':offset, :limit\',' . "\n";
            $buffer .= '        array(' . "\n";
            $buffer .= '            \'offset\' => $GLOBALS[\'config\'][\'limits\'][\'' . $table . '\'] * ($_GET[\'page\'] - 1),' . "\n";
            $buffer .= '            \'limit\'  => $GLOBALS[\'config\'][\'limits\'][\'' . $table . '\'],' . "\n";
            $buffer .= '        ),' . "\n";
            $buffer .= '    ),' . "\n";
            $buffer .= '));' . "\n";
            $buffer .= "\n";
            $buffer .= '$_view[\'' . $table . '_count\'] = select_' . $table . '(array(' . "\n";
            $buffer .= '    \'select\' => \'COUNT(*) AS count\',' . "\n";
            $buffer .= '    \'where\'  => $filters[\'where\'] ? $filters[\'where\'] : null,' . "\n";
            $buffer .= '));' . "\n";
            $buffer .= '$_view[\'' . $table . '_count\'] = $_view[\'' . $table . '_count\'][0][\'count\'];' . "\n";
            $buffer .= '$_view[\'' . $table . '_page\']  = ceil($_view[\'' . $table . '_count\'] / $GLOBALS[\'config\'][\'limits\'][\'' . $table . '\']);' . "\n";
            $buffer .= '' . "\n";
            $buffer .= '// ページャー' . "\n";
            $buffer .= '$pager = ui_pager(array(' . "\n";
            $buffer .= '    \'key\'   => \'page\',' . "\n";
            $buffer .= '    \'count\' => $_view[\'' . $table . '_count\'],' . "\n";
            $buffer .= '    \'size\'  => $GLOBALS[\'config\'][\'limits\'][\'' . $table . '\'],' . "\n";
            $buffer .= '    \'width\' => $GLOBALS[\'config\'][\'pagers\'][\'' . $table . '\'],' . "\n";
            $buffer .= '    \'query\' => \'?\' . $filters[\'pager\'] . \'&amp;\',' . "\n";
            $buffer .= '));' . "\n";
            $buffer .= '$_view[\'' . $table . '_pager\'] = $pager[\'first\'] . \' \' . $pager[\'back\'] . \' \' . implode(\' | \', $pager[\'pages\']) . \' \' . $pager[\'next\'] . \' \' . $pager[\'last\'];' . "\n";

            $scaffold .= db_scaffold_output($controller_index_file, $buffer);

            $buffer  = '<?php' . "\n";
            $buffer .= "\n";
            $buffer .= 'if ($_SERVER[\'REQUEST_METHOD\'] === \'POST\') {' . "\n";
            $buffer .= '    // ワンタイムトークン' . "\n";
            $buffer .= '    if (!token(\'check\')) {' . "\n";
            $buffer .= '        error(\'不正なアクセスです。\');' . "\n";
            $buffer .= '    }' . "\n";
            $buffer .= '' . "\n";
            $buffer .= '    // 入力データを整理' . "\n";
            $buffer .= '    $post = array(' . "\n";
            $buffer .= '        \'data\' => normalize_' . $table . '(array(' . "\n";
            $buffer .= $controller_normalize;
            $buffer .= '        ))' . "\n";
            $buffer .= '    );' . "\n";
            $buffer .= '' . "\n";
            $buffer .= '    // 入力データを検証＆登録' . "\n";
            $buffer .= '    $warnings = validate_' . $table . '($post[\'data\']);' . "\n";
            $buffer .= '    if (empty($warnings)) {' . "\n";
            $buffer .= '        $_SESSION[\'post\'][\'data\'] = $post[\'data\'];' . "\n";
            $buffer .= '' . "\n";
            $buffer .= '        // フォワード' . "\n";
            $buffer .= '        forward(\'/' . $table . '/' . 'post\');' . "\n";
            $buffer .= '    } else {' . "\n";
            $buffer .= '        $_view[\'data\'] = $post[\'data\'];' . "\n";
            $buffer .= '' . "\n";
            $buffer .= '        $_view[\'warnings\'] = $warnings;' . "\n";
            $buffer .= '    }' . "\n";
            $buffer .= '} else {' . "\n";
            $buffer .= '    // 初期データを取得' . "\n";
            $buffer .= '    if (empty($_GET[\'' . $primary_key . '\'])) {' . "\n";
            $buffer .= '        $_view[\'data\'] = default_' . $table . '();' . "\n";
            $buffer .= '    } else {' . "\n";
            $buffer .= '        $' . $table . ' = select_' . $table . '(array(' . "\n";
            $buffer .= '            \'where\' => array(' . "\n";
            $buffer .= '                \'' . $primary_key . ' = :' . $primary_key . '\',' . "\n";
            $buffer .= '                array(' . "\n";
            $buffer .= '                    \'' . $primary_key . '\' => $_GET[\'' . $primary_key . '\'],' . "\n";
            $buffer .= '                ),' . "\n";
            $buffer .= '            ),' . "\n";
            $buffer .= '        ));' . "\n";
            $buffer .= '        if (empty($' . $table . ')) {' . "\n";
            $buffer .= '            warning(\'編集データが見つかりません。\');' . "\n";
            $buffer .= '        } else {' . "\n";
            $buffer .= '            $_view[\'data\'] = $' . $table . '[0];' . "\n";
            $buffer .= '        }' . "\n";
            $buffer .= '    }' . "\n";
            $buffer .= '' . "\n";
            $buffer .= '    // 投稿セッションを初期化' . "\n";
            $buffer .= '    unset($_SESSION[\'post\']);' . "\n";
            $buffer .= '}' . "\n";

            $scaffold .= db_scaffold_output($controller_form_file, $buffer);

            $buffer  = '<?php' . "\n";
            $buffer .= "\n";
            $buffer .= '// フォワードを確認' . "\n";
            $buffer .= 'if (forward() === null) {' . "\n";
            $buffer .= '    error(\'不正なアクセスです。\');' . "\n";
            $buffer .= '}' . "\n";
            $buffer .= '' . "\n";
            $buffer .= '// 投稿データを確認' . "\n";
            $buffer .= 'if (empty($_SESSION[\'post\'])) {' . "\n";
            $buffer .= '    // リダイレクト' . "\n";
            $buffer .= '    redirect(\'/' . $table . '/form\');' . "\n";
            $buffer .= '}' . "\n";
            $buffer .= '' . "\n";
            $buffer .= '// トランザクションを開始' . "\n";
            $buffer .= 'db_transaction();' . "\n";
            $buffer .= '' . "\n";
            $buffer .= 'if (empty($_SESSION[\'post\'][\'data\'][\'' . $primary_key . '\'])) {' . "\n";
            $buffer .= '    // 記事を登録' . "\n";
            $buffer .= '    $resource = insert_' . $table . '(array(' . "\n";
            $buffer .= '        \'values\' => array(' . "\n";
            $buffer .= $controller_insert;
            $buffer .= '        ),' . "\n";
            $buffer .= '    ));' . "\n";
            $buffer .= '    if (!$resource) {' . "\n";
            $buffer .= '        error(\'データを登録できません。\');' . "\n";
            $buffer .= '    }' . "\n";
            $buffer .= '} else {' . "\n";
            $buffer .= '    // 記事を編集' . "\n";
            $buffer .= '    $resource = update_' . $table . '(array(' . "\n";
            $buffer .= '        \'set\'   => array(' . "\n";
            $buffer .= $controller_update;
            $buffer .= '        ),' . "\n";
            $buffer .= '        \'where\' => array(' . "\n";
            $buffer .= '            \'' . $primary_key . ' = :' . $primary_key . '\',' . "\n";
            $buffer .= '            array(' . "\n";
            $buffer .= '                \'' . $primary_key . '\' => $_SESSION[\'post\'][\'data\'][\'id\'],' . "\n";
            $buffer .= '            ),' . "\n";
            $buffer .= '        ),' . "\n";
            $buffer .= '    ));' . "\n";
            $buffer .= '    if (!$resource) {' . "\n";
            $buffer .= '        error(\'データを編集できません。\');' . "\n";
            $buffer .= '    }' . "\n";
            $buffer .= '}' . "\n";
            $buffer .= '' . "\n";
            $buffer .= '// トランザクションを終了' . "\n";
            $buffer .= 'db_commit();' . "\n";
            $buffer .= '' . "\n";
            $buffer .= '// 投稿セッションを初期化' . "\n";
            $buffer .= 'unset($_SESSION[\'post\']);' . "\n";
            $buffer .= '' . "\n";
            $buffer .= '// リダイレクト' . "\n";
            $buffer .= 'redirect(\'/' . $table . '/' . MAIN_DEFAULT_WORK . '?ok=post\');' . "\n";

            $scaffold .= db_scaffold_output($controller_post_file, $buffer);

            $buffer  = '<?php' . "\n";
            $buffer .= "\n";
            $buffer .= '// ワンタイムトークン' . "\n";
            $buffer .= 'if (!token(\'check\')) {' . "\n";
            $buffer .= '    error(\'不正なアクセスです。\');' . "\n";
            $buffer .= '}' . "\n";
            $buffer .= '' . "\n";
            $buffer .= '// トランザクションを開始' . "\n";
            $buffer .= 'db_transaction();' . "\n";
            $buffer .= '' . "\n";
            $buffer .= '// 記事を削除' . "\n";
            $buffer .= '$resource = delete_' . $table . '(array(' . "\n";
            $buffer .= '    \'where\' => array(' . "\n";
            $buffer .= '        \'' . $primary_key . ' = :' . $primary_key . '\',' . "\n";
            $buffer .= '        array(' . "\n";
            $buffer .= '            \'' . $primary_key . '\' => $_POST[\'' . $primary_key . '\'],' . "\n";
            $buffer .= '        ),' . "\n";
            $buffer .= '    ),' . "\n";
            $buffer .= '));' . "\n";
            $buffer .= 'if (!$resource) {' . "\n";
            $buffer .= '    error(\'データを削除できません。\');' . "\n";
            $buffer .= '}' . "\n";
            $buffer .= '' . "\n";
            $buffer .= '// トランザクションを終了' . "\n";
            $buffer .= 'db_commit();' . "\n";
            $buffer .= '' . "\n";
            $buffer .= '// リダイレクト' . "\n";
            $buffer .= 'redirect(\'/' . $table . '/' . MAIN_DEFAULT_WORK . '?ok=delete\');' . "\n";

            $scaffold .= db_scaffold_output($controller_delete_file, $buffer);
        }

        // 単体テスト用のダミーデータを作成
        $test_insert  = '';
        $test_insert .= '    $insert_' . $table . ' = array(' . "\n";
        $test_insert .= '        1 => array(' . "\n";
        $test_insert .= str_replace('[N]', 1, $test_data);
        $test_insert .= '        ),' . "\n";
        $test_insert .= '        2 => array(' . "\n";
        $test_insert .= str_replace('[N]', 2, $test_data);
        $test_insert .= '        ),' . "\n";
        $test_insert .= '        3 => array(' . "\n";
        $test_insert .= str_replace('[N]', 3, $test_data);
        $test_insert .= '        ),' . "\n";
        $test_insert .= '    );' . "\n";

        $test_update = '';
        $test_update .= '    $update_' . $table . ' = array(' . "\n";
        $test_update .= '        3 => array(' . "\n";
        $test_update .= str_replace('[N]', 3, $test_data);
        $test_update .= '        ),' . "\n";
        $test_update .= '    );' . "\n";

        // モデルの単体テストを作成
        $buffer  = '<?php' . "\n";
        $buffer .= "\n";
        $buffer .= 'model(\'' . $table . '.php\');' . "\n";
        $buffer .= "\n";
        $buffer .= '// トランザクションを開始' . "\n";
        $buffer .= 'db_transaction();' . "\n";
        $buffer .= "\n";
        $buffer .= '// 登録のテスト' . "\n";
        $buffer .= '{' . "\n";
        $buffer .= '    // ダミーデータ' . "\n";
        $buffer .= $test_insert;
        $buffer .= "\n";
        $buffer .= '    // 登録' . "\n";
        $buffer .= '    foreach ($insert_' . $table . ' as $insert_data) {' . "\n";
        $buffer .= '        $warnings = validate_' . $table . '(normalize_' . $table . '($insert_data));' . "\n";
        $buffer .= '        if (empty($warnings)) {' . "\n";
        $buffer .= '            insert_' . $table . '(array(' . "\n";
        $buffer .= '                \'values\' => $insert_data,' . "\n";
        $buffer .= '            ));' . "\n";
        $buffer .= '        } else {' . "\n";
        $buffer .= '            debug($warnings);' . "\n";
        $buffer .= '        }' . "\n";
        $buffer .= '    }' . "\n";
        $buffer .= "\n";
        $buffer .= '    // テスト' . "\n";
        $buffer .= '    $' . $table . ' = select_' . $table . '(array(' . "\n";
        $buffer .= '        \'select\' => \'' . $test_select_data . '\',' . "\n";
        $buffer .= '        \'limit\'  => 10,' . "\n";
        $buffer .= '    ));' . "\n";
        $buffer .= "\n";
        $buffer .= '    test_equals(\'count_' . $table . '\', count($' . $table . '), 3);' . "\n";
        $buffer .= "\n";
        $buffer .= '    for ($i = 1; $i <= 3; $i++) {' . "\n";
        $buffer .= '        $inserted_data = array_shift($' . $table . ');' . "\n";
        $buffer .= '        $test_data     = array(' . "\n";
        $buffer .= '            $i => $inserted_data,' . "\n";
        $buffer .= '        );' . "\n";
        $buffer .= '        test_array_subset(\'insert_' . $table . ' \' . $i, $test_data, $insert_' . $table . '[$i]);' . "\n";
        $buffer .= '    }' . "\n";
        $buffer .= '}' . "\n";
        $buffer .= "\n";

        if ($primary_flag == true) {
            $buffer .= '// 更新のテスト' . "\n";
            $buffer .= '{' . "\n";
            $buffer .= '    // ダミーデータ' . "\n";
            $buffer .= $test_update;
            $buffer .= "\n";
            $buffer .= '    // 更新' . "\n";
            $buffer .= '    $warnings = validate_' . $table . '(normalize_' . $table . '($update_' . $table . '[3]));' . "\n";
            $buffer .= '    if (empty($warnings)) {' . "\n";
            $buffer .= '        update_' . $table . '(array(' . "\n";
            $buffer .= '            \'set\'   => $update_' . $table . '[3],' . "\n";
            $buffer .= '            \'where\' => \'id = 3\',' . "\n";
            $buffer .= '        ));' . "\n";
            $buffer .= '    } else {' . "\n";
            $buffer .= '        debug($warnings);' . "\n";
            $buffer .= '    }' . "\n";
            $buffer .= "\n";
            $buffer .= '    // テスト' . "\n";
            $buffer .= '    $' . $table . ' = select_' . $table . '(array(' . "\n";
            $buffer .= '        \'select\' => \'' . $test_select_data . '\',' . "\n";
            $buffer .= '        \'limit\'  => 10,' . "\n";
            $buffer .= '    ));' . "\n";
            $buffer .= "\n";
            $buffer .= '    $updated_data = array_pop($' . $table . ');' . "\n";
            $buffer .= '    $test_data    = array(' . "\n";
            $buffer .= '        3 => $updated_data,' . "\n";
            $buffer .= '    );' . "\n";
            $buffer .= '    test_array_subset(\'update_' . $table . '\', $test_data, $update_' . $table . '[3]);' . "\n";
            $buffer .= '}' . "\n";
            $buffer .= "\n";
            $buffer .= '// 削除のテスト' . "\n";
            $buffer .= '{' . "\n";
            $buffer .= '    // 削除' . "\n";
            $buffer .= '    delete_' . $table . '(array(' . "\n";
            $buffer .= '        \'where\' => \'id = 3\',' . "\n";
            $buffer .= '    ));' . "\n";
            $buffer .= "\n";
            $buffer .= '    // テスト' . "\n";
            $buffer .= '    $' . $table . ' = select_' . $table . '(array(' . "\n";
            $buffer .= '        \'limit\' => 10,' . "\n";
            $buffer .= '    ));' . "\n";
            $buffer .= "\n";
            $buffer .= '    test_equals(\'delete_' . $table . '\', count($' . $table . '), 2);' . "\n";
            $buffer .= '}' . "\n";
            $buffer .= "\n";
        }

        $buffer .= "// トランザクションをロールバック\n";
        $buffer .= 'db_rollback();' . "\n";

        $scaffold .= db_scaffold_output($test_model_file, $buffer);

        // ビューの単体テストを作成
        if ($primary_flag == true) {
            $buffer  = '<?php' . "\n";
            $buffer .= "\n";
            $buffer .= '// 一覧画面のテスト' . "\n";
            $buffer .= '{' . "\n";
            $buffer .= '    // ダミーデータ' . "\n";
            $buffer .= $test_insert;
            $buffer .= "\n";
            $buffer .= '    // 割り当て' . "\n";
            $buffer .= '    $_view[\'' . $table . '\'] = $insert_' . $table . ';' . "\n";
            $buffer .= "\n";
            $buffer .= '    // テスト' . "\n";
            $buffer .= '    $html = view(\'' . $table . '/index.php\', true);' . "\n";
            $buffer .= "\n";
            $buffer .= '    test_contains(\'' . $table . '/index 1\', $html, \'<td>\' . $insert_' . $table . '[1][\'' . $primary_key . '\'] . \'</td>\');' . "\n";
            $buffer .= '    test_contains(\'' . $table . '/index 2\', $html, \'<td>\' . $insert_' . $table . '[2][\'' . $primary_key . '\'] . \'</td>\');' . "\n";
            $buffer .= '    test_contains(\'' . $table . '/index 3\', $html, \'<td>\' . $insert_' . $table . '[3][\'' . $primary_key . '\'] . \'</td>\');' . "\n";
            $buffer .= '}' . "\n";
            $buffer .= "\n";
            $buffer .= '// 登録画面のテスト' . "\n";
            $buffer .= '{' . "\n";
            $buffer .= '    // テスト' . "\n";
            $buffer .= '    $_view[\'data\'] = $insert_' . $table . '[1];' . "\n";
            $buffer .= "\n";
            $buffer .= '    $html = view(\'' . $table . '/form.php\', true);' . "\n";
            $buffer .= "\n";
            $buffer .= '    test_contains(\'' . $table . '/form\', $html, \'value="\' . $insert_' . $table . '[1][\'' . $primary_key . '\'] . \'"\');' . "\n";
            $buffer .= '}' . "\n";

            $scaffold .= db_scaffold_output($test_view_file, $buffer);
        }

        // コントローラの単体テストを作成
        if ($primary_flag == true) {
            $buffer  = '<?php' . "\n";
            $buffer .= "\n";
            $buffer .= 'model();' . "\n";
            $buffer .= "\n";
            $buffer .= '// トランザクションを開始' . "\n";
            $buffer .= 'db_transaction();' . "\n";
            $buffer .= "\n";
            $buffer .= '// 一覧画面のテスト' . "\n";
            $buffer .= '{' . "\n";
            $buffer .= '    // ダミーデータ' . "\n";
            $buffer .= $test_insert;
            $buffer .= "\n";
            $buffer .= '    // 登録' . "\n";
            $buffer .= '    foreach ($insert_' . $table . ' as $insert_data) {' . "\n";
            $buffer .= '        $warnings = validate_' . $table . '(normalize_' . $table . '($insert_data));' . "\n";
            $buffer .= '        if (empty($warnings)) {' . "\n";
            $buffer .= '            insert_' . $table . '(array(' . "\n";
            $buffer .= '                \'values\' => $insert_data,' . "\n";
            $buffer .= '            ));' . "\n";
            $buffer .= '        } else {' . "\n";
            $buffer .= '            debug($warnings);' . "\n";
            $buffer .= '        }' . "\n";
            $buffer .= '    }' . "\n";
            $buffer .= "\n";
            $buffer .= '    // テスト' . "\n";
            $buffer .= '    $_params = array(\'' . $table . '\', \'index\');' . "\n";
            $buffer .= '    controller(\'' . $table . '/index.php\');' . "\n";
            $buffer .= '    $html = view(\'' . $table . '/index.php\', true);' . "\n";
            $buffer .= "\n";
            $buffer .= '    test_contains(\'' . $table . '/index 1\', $html, \'<td>\' . $insert_' . $table . '[1][\'' . $primary_key . '\'] . \'</td>\');' . "\n";
            $buffer .= '    test_contains(\'' . $table . '/index 2\', $html, \'<td>\' . $insert_' . $table . '[2][\'' . $primary_key . '\'] . \'</td>\');' . "\n";
            $buffer .= '    test_contains(\'' . $table . '/index 3\', $html, \'<td>\' . $insert_' . $table . '[3][\'' . $primary_key . '\'] . \'</td>\');' . "\n";
            $buffer .= '}' . "\n";
            $buffer .= "\n";
            $buffer .= '// 登録画面のテスト' . "\n";
            $buffer .= '{' . "\n";
            $buffer .= '    // テスト' . "\n";
            $buffer .= '    $_params = array(\'' . $table . '\', \'form\');' . "\n";
            $buffer .= '    $_GET[\'' . $primary_key . '\'] = 3;' . "\n";
            $buffer .= '    controller(\'' . $table . '/form.php\');' . "\n";
            $buffer .= '    $html = view(\'' . $table . '/form.php\', true);' . "\n";
            $buffer .= "\n";
            $buffer .= '    test_contains(\'' . $table . '/form\', $html, \'value="\' . $insert_' . $table . '[3][\'' . $primary_key . '\'] . \'"\');' . "\n";
            $buffer .= '}' . "\n";
            $buffer .= "\n";
            $buffer .= "// トランザクションをロールバック\n";
            $buffer .= 'db_rollback();' . "\n";

            $scaffold .= db_scaffold_output($test_controller_file, $buffer);
        }

        // テスト仕様書を作成
        if ($primary_flag == true) {
            $csv    = array();
            $number = 0;

            $csv[] = array('No.', '画面', '確認内容', '区分', '前提', '動作', '期待', 'テスト日', 'テスト結果', '担当者', '備考');
            $csv[] = array(++$number, '一覧', '表示', '正常', '', '一覧画面にアクセス', '正常に表示される', '', '', '', '');

            foreach ($test_list_data as $data) {
                $csv[] = array(++$number, '', '', '正常', '', '一覧画面にアクセス', $data, '', '', '', '');
            }

            $csv[] = array(++$number, '', '', '正常', '11件以上登録されている', '一覧画面にアクセス', 'ページャーが表示される', '', '', '', '');
            $csv[] = array(++$number, '', '', '正常', '51件以上登録されている', '一覧画面にアクセス', 'ページャーの数値が5つまで表示される', '', '', '', '');
            $csv[] = array(++$number, '', '検索', '正常', '検索条件を入力しない', '検索ボタンをクリック', '絞り込まれずに表示される', '', '', '', '');

            foreach ($test_search_data as $data) {
                $csv[] = array(++$number, '', '', '正常', $data . 'に検索条件を入力する', '検索ボタンをクリック', $data . 'を検索して絞りこめる', '', '', '', '');

                $first = false;
            }

            $csv[] = array(++$number, '', '遷移', '正常', '', '編集リンクをクリック', '編集画面へ遷移する', '', '', '', '');
            $csv[] = array(++$number, '', '', '正常', '11件以上登録されていて、最初のページにいる', 'ページャーの「<<」をクリック', '何も起こらない', '', '', '', '');
            $csv[] = array(++$number, '', '', '正常', '', 'ページャーの「<」をクリック', '何も起こらない', '', '', '', '');
            $csv[] = array(++$number, '', '', '正常', '11件以上登録されていて、最初のページにいない', 'ページャーの「<<」をクリック', '検索条件を保持したまま最初のページに移動できる', '', '', '', '');
            $csv[] = array(++$number, '', '', '正常', '', 'ページャーの「<」をクリック', '検索条件を保持したまま一つ前のページに移動できる', '', '', '', '');
            $csv[] = array(++$number, '', '', '正常', '11件以上登録されていて、最後のページにいる', 'ページャーの「>>」をクリック', '何も起こらない', '', '', '', '');
            $csv[] = array(++$number, '', '', '正常', '', 'ページャーの「>」をクリック', '何も起こらない', '', '', '', '');
            $csv[] = array(++$number, '', '', '正常', '11件以上登録されていて、最後のページにいない', 'ページャーの「>>」をクリック', '検索条件を保持したまま最後のページに移動できる', '', '', '', '');
            $csv[] = array(++$number, '', '', '正常', '', 'ページャーの「>」をクリック', '検索条件を保持したまま一つ後のページに移動できる', '', '', '', '');
            $csv[] = array(++$number, '', '', '正常', '11件以上登録されていて、(N)ページにいる', 'ページャーの「(N)」をクリック', '何も起こらない', '', '', '', '');
            $csv[] = array(++$number, '', '', '正常', '11件以上登録されていて、(N)ページにいない', 'ページャーの「(N)」をクリック', '検索条件を保持したまま(N)ページに移動できる', '', '', '', '');
            $csv[] = array(++$number, '登録画面', '表示', '正常', '', '登録画面にアクセス', '正常に表示される', '', '', '', '');

            foreach ($test_insert_data as $data) {
                $csv[] = array(++$number, '', '', '正常', '', '登録画面にアクセス', $data, '', '', '', '');
            }

            $flag = false;
            foreach ($test_validate_data as $data) {
                if ($flag === true) {
                    $content = '';
                } else {
                    $content = '登録';

                    $flag = true;
                }

                $csv[] = array(++$number, '', $content, '異常', $data, '登録ボタンをクリック', 'エラーメッセージが表示される', '', '', '', '');
            }

            $csv[] = array(++$number, '', '', '正常', 'エラーが無い', '登録ボタンをクリック', '一覧画面へ遷移し、データが登録されている', '', '', '', '');
            $csv[] = array(++$number, '編集画面', '表示', '正常', '', '編集画面にアクセス', '正常に表示される', '', '', '', '');

            foreach ($test_update_data as $data) {
                $csv[] = array(++$number, '', '', '正常', '', '編集画面にアクセス', $data, '', '', '', '');
            }

            $csv[] = array(++$number, '', '', '正常', '', '編集画面にアクセス', '登録した内容が表示される', '', '', '', '');

            $flag = false;
            foreach ($test_validate_data as $data) {
                if ($flag === true) {
                    $content = '';
                } else {
                    $content = '登録';

                    $flag = true;
                }

                $csv[] = array(++$number, '', $content, '異常', $data, '登録ボタンをクリック', 'エラーメッセージが表示される', '', '', '', '');
            }

            $csv[] = array(++$number, '', '', '正常', 'エラーが無い', '登録ボタンをクリック', '一覧画面へ遷移し、データが更新されている', '', '', '', '');
            $csv[] = array(++$number, '', '', '正常', '', '削除ボタンをクリック', '一覧画面へ遷移し、データが削除されている', '', '', '', '');

            $buffer = '';
            foreach ($csv as $row) {
                $flag = false;
                foreach ($row as $col) {
                    if ($flag === true) {
                        $buffer .= ',';
                    } else {
                        $flag = true;
                    }

                    $buffer .= '"' . str_replace('"', '""', mb_convert_encoding($col, 'SJIS-WIN', 'UTF-8')) . '"';
                }
                $buffer .= "\n";
            }

            $scaffold .= db_scaffold_output($test_specification_file, $buffer);
        }

        $scaffold .= "\n";
    }

    // ホーム画面を作成
    $view_home_file       = $views . MAIN_DEFAULT_MODE . '/' . MAIN_DEFAULT_WORK . '.php';
    $controller_home_file = $controllers . MAIN_DEFAULT_MODE . '/' . MAIN_DEFAULT_WORK . '.php';

    $scaffold .= '[index]' . "\n";

    $buffer  = '<?php import(\'app/views/header.php\') ?>' . "\n";
    $buffer .= "\n";
    $buffer .= '        <ul>' . "\n";

    foreach ($results as $result) {
        if (DATABASE_TYPE === 'pdo_mysql' || DATABASE_TYPE === 'mysql') {
            $table_comment = $result['Comment'];
        } else {
            $table_comment = null;
        }

        $table = array_shift($result);

        if (regexp_match('^' . DATABASE_PREFIX . $exclude_prefix, $table)) {
            continue;
        }
        if (empty($primary_keys[$table])) {
            continue;
        }

        $buffer .= '            <li><a href="<?php t(MAIN_FILE) ?>/' . $table . '">' . ($table_comment ? $table_comment : $table) . '</a></li>' . "\n";
    }

    $buffer .= '        </ul>' . "\n";

    $buffer .= "\n";
    $buffer .= '<?php import(\'app/views/footer.php\') ?>' . "\n";

    $scaffold .= db_scaffold_output($view_home_file, $buffer);

    $buffer  = '<?php' . "\n";

    $scaffold .= db_scaffold_output($controller_home_file, $buffer);

    // ヘッダを作成
    $buffer  = '<!DOCTYPE html>' . "\n";
    $buffer .= '<html>' . "\n";
    $buffer .= '    <head>' . "\n";
    $buffer .= '        <meta charset="<?php t(MAIN_CHARSET) ?>" />' . "\n";
    $buffer .= '        <title>scaffold</title>' . "\n";

    ob_start();
    style();
    $buffer .= ob_get_contents();
    ob_end_clean();

    $buffer .= '    </head>' . "\n";
    $buffer .= '    <body>' . "\n";
    $buffer .= '        <h1>scaffold</h1>' . "\n";

    $scaffold .= db_scaffold_output($header_file, $buffer);

    // フッタを作成
    $buffer  = '    </body>' . "\n";
    $buffer .= '</html>' . "\n";

    $scaffold .= db_scaffold_output($footer_file, $buffer);

    // beforeファイルを作成
    $buffer  = '<?php' . "\n";
    $buffer .= "\n";
    $buffer .= 'import(\'' . $config_file . '\');' . "\n";

    $scaffold .= db_scaffold_output($before_file, $buffer);

    // afterファイルを作成
    $buffer  = '<?php' . "\n";
    $buffer .= "\n";
    $buffer .= '// ワンタイムトークン' . "\n";
    $buffer .= '$_view[\'token\'] = token(\'create\');' . "\n";

    $scaffold .= db_scaffold_output($after_file, $buffer);

    // 設定ファイルを作成
    $max_length = 0;
    foreach ($results as $result) {
        $table = array_shift($result);

        if (regexp_match('^' . DATABASE_PREFIX . $exclude_prefix, $table)) {
            continue;
        }
        if (empty($primary_keys[$table])) {
            continue;
        }

        $max_length = strlen($table) > $max_length ? strlen($table) : $max_length;
    }

    $buffer  = '<?php' . "\n";
    $buffer .= "\n";
    $buffer .= '/*******************************************************************************' . "\n";
    $buffer .= '' . "\n";
    $buffer .= ' 設定ファイル' . "\n";
    $buffer .= '' . "\n";
    $buffer .= '*******************************************************************************/' . "\n";
    $buffer .= "\n";
    $buffer .= '/* 表示件数 */' . "\n";
    $buffer .= '$GLOBALS[\'config\'][\'limits\'] = array(' . "\n";

    foreach ($results as $result) {
        $table = array_shift($result);

        if (regexp_match('^' . DATABASE_PREFIX . $exclude_prefix, $table)) {
            continue;
        }
        if (empty($primary_keys[$table])) {
            continue;
        }

        $space = str_repeat(' ', $max_length - strlen($table));;

        $buffer .= '    \'' . $table . '\' ' . $space . '=> 10,' . "\n";
    }

    $buffer .= ');' . "\n";
    $buffer .= "\n";
    $buffer .= '/* ページャーの幅 */' . "\n";
    $buffer .= '$GLOBALS[\'config\'][\'pagers\'] = array(' . "\n";

    foreach ($results as $result) {
        $table = array_shift($result);

        if (regexp_match('^' . DATABASE_PREFIX . $exclude_prefix, $table)) {
            continue;
        }
        if (empty($primary_keys[$table])) {
            continue;
        }

        $space = str_repeat(' ', $max_length - strlen($table));;

        $buffer .= '    \'' . $table . '\' ' . $space . '=> 5,' . "\n";
    }

    $buffer .= ');' . "\n";

    $scaffold .= db_scaffold_output($config_file, $buffer);

    // 完了メッセージ
    $scaffold .= "\n";
    $scaffold .= "完了しました。\n";

    // 結果を出力
    echo "<!DOCTYPE html>\n";
    echo "<html>\n";
    echo "<head>\n";
    echo "<meta charset=\"" . t(MAIN_CHARSET, true) . "\" />\n";
    echo "<title>Scaffold</title>\n";

    style();

    echo "</head>\n";
    echo "<body>\n";
    echo "<h1>Scaffold</h1>\n";
    echo "<pre><code>" . t($scaffold, true) . "</code></pre>\n";
    echo "</body>\n";
    echo "</html>\n";
} else {
    // 初期画面を出力
    echo "<!DOCTYPE html>\n";
    echo "<html>\n";
    echo "<head>\n";
    echo "<meta charset=\"" . t(MAIN_CHARSET, true) . "\" />\n";
    echo "<title>Scaffold</title>\n";

    style();

    echo "</head>\n";
    echo "<body>\n";
    echo "<h1>Scaffold</h1>\n";

    echo "<form action=\"" . t(MAIN_FILE, true) . "/" . t($_REQUEST['_mode'], true) . "/" . t($_REQUEST['_work'], true) . "\" method=\"post\">\n";
    echo "<fieldset>\n";
    echo "<legend>scaffold</legend>\n";
    echo "<dl>\n";
    echo "<dt>代理キー</dt>\n";
    echo "<dd><input type=\"text\" name=\"primary_key\" size=\"20\" value=\"" . t($primary_key, true) . "\" /></dd>\n";
    echo "<dt>データ作成日時</dt>\n";
    echo "<dd><input type=\"text\" name=\"created_key\" size=\"20\" value=\"" . t($created_key, true) . "\" /></dd>\n";
    echo "<dt>データ修正日時</dt>\n";
    echo "<dd><input type=\"text\" name=\"modified_key\" size=\"20\" value=\"" . t($modified_key, true) . "\" /></dd>\n";
    echo "<dt>データ削除日時</dt>\n";
    echo "<dd><input type=\"text\" name=\"deleted_key\" size=\"20\" value=\"" . t($deleted_key, true) . "\" /></dd>\n";
    echo "<dt>Validatorプラグイン</dt>\n";
    echo "<dd>\n";

    if ($plugin_validator === true) {
        echo "<label><input type=\"radio\" name=\"plugin_validator\" value=\"1\" checked=\"checked\" /> 使用する</label>\n";
        echo "<label><input type=\"radio\" name=\"plugin_validator\" value=\"0\" /> 使用しない</label>\n";
    } else {
        echo "<label><input type=\"radio\" name=\"plugin_validator\" value=\"1\" /> 使用する</label>\n";
        echo "<label><input type=\"radio\" name=\"plugin_validator\" value=\"0\" checked=\"checked\" /> 使用しない</label>\n";
    }

    echo "</dd>\n";
    echo "</dl>\n";
    echo "<p><input type=\"submit\" value=\"実行する\" /></p>\n";
    echo "</fieldset>\n";
    echo "</form>\n";

    echo "</body>\n";
    echo "</html>\n";
}

exit;
