<?php

/*
 * なんちゃって個人情報 http://kazina.com/dummy/ から取得した個人情報を整形してJSONで返す
 */

// 対象ファイル
define('FILE_NAME', 'data.csv');

// CSVファイルから個人情報を取得
$data = '';
if ($fp = fopen(FILE_NAME, 'r')) {
    $random = rand(1, 50);

    $i = 0;
    while ($line = fgets($fp)) {
        if ($random === $i++) {
            $data = $line;

            break;
        }
    }

    fclose($fp);
}

// 取得した情報を整形
if ($data === '') {
    exit('Error');
} else {
    list($name, $kana, $email, $gender, $age, $birthday, $marriage, $blood, $prefecture, $tel, $mobile, $carrier, $curry) = explode(',', $line);
}

$kana = mb_convert_kana($kana, 'C');

list($name_sei, $name_mei) = explode(' ', $name);
list($kana_sei, $kana_mei) = explode(' ', $kana);

list($email_account, $email_domain) = explode('@', $email);

$tel    = str_replace(' ', '0', $tel);
$mobile = str_replace(' ', '0', $mobile);

$tels    = explode('-', $tel);
$mobiles = explode('-', $mobile);

$birthday_year  = date('Y', strtotime($birthday));
$birthday_month = date('m', strtotime($birthday));
$birthday_day   = date('d', strtotime($birthday));

$birthday = $birthday_year . '-' . $birthday_month . '-' . $birthday_day;

$prefectures = array(
    '北海道'   => '01',
    '青森県'   => '02',
    '岩手県'   => '03',
    '宮城県'   => '04',
    '秋田県'   => '05',
    '山形県'   => '06',
    '福島県'   => '07',
    '茨城県'   => '08',
    '栃木県'   => '09',
    '群馬県'   => '10',
    '埼玉県'   => '11',
    '千葉県'   => '12',
    '東京都'   => '13',
    '神奈川県' => '14',
    '新潟県'   => '15',
    '富山県'   => '16',
    '石川県'   => '17',
    '福井県'   => '18',
    '山梨県'   => '19',
    '長野県'   => '20',
    '岐阜県'   => '21',
    '静岡県'   => '22',
    '愛知県'   => '23',
    '三重県'   => '24',
    '滋賀県'   => '25',
    '京都府'   => '26',
    '大阪府'   => '27',
    '兵庫県'   => '28',
    '奈良県'   => '29',
    '和歌山県' => '30',
    '鳥取県'   => '31',
    '島根県'   => '32',
    '岡山県'   => '33',
    '広島県'   => '34',
    '山口県'   => '35',
    '徳島県'   => '36',
    '香川県'   => '37',
    '愛媛県'   => '38',
    '高知県'   => '39',
    '福岡県'   => '40',
    '佐賀県'   => '41',
    '長崎県'   => '42',
    '熊本県'   => '43',
    '大分県'   => '44',
    '宮崎県'   => '45',
    '鹿児島県' => '46',
    '沖縄県'   => '47',
);
$prefecture_id = $prefectures[$prefecture];

// 結果を出力
echo json_encode(array(
    'name'           => $name,
    'name_sei'       => $name_sei,
    'name_mei'       => $name_mei,
    'kana_sei'       => $kana_sei,
    'kana_mei'       => $kana_mei,
    'kana'           => $kana,
    'email'          => $email,
    'email_account'  => $email_account,
    'email_domain'   => $email_domain,
    'gender'         => $gender,
    'age'            => $age,
    'birthday'       => $birthday,
    'birthday_year'  => $birthday_year,
    'birthday_month' => $birthday_month,
    'birthday_day'   => $birthday_day,
    'marriage'       => $marriage,
    'blood'          => $blood,
    'prefecture'     => $prefecture,
    'prefecture_id'  => $prefecture_id,
    'tel'            => $tel,
    'tels'           => $tels,
    'mobile'         => $mobile,
    'mobiles'        => $mobiles,
    'carrier'        => $carrier,
    'curry'          => $curry,
));
exit;
