test.scenario = [
    // 初期ページから管理者用ページに移動
    function() {
        $('a:contains("管理者用")')[0].click();
    },
    // 管理者用ページにログイン
    function() {
        var form = $('form:eq(0)');

        form.find('input[name="username"]').val('admin');
        form.find('input[name="password"]').val('1234');
        form.find('input[type="submit"]').click();
    },
    // 名簿登録ページに移動
    function() {
        $('a:contains("名簿登録")')[0].click();
    },
    // ダミーの個人情報で名簿を登録
    function() {
        $.getJSON(test.config.http_path + 'personal/', function(data) {
            var form = $('form:eq(0)');

            var grade = Math.floor(Math.random() * 6);

            var birthday_month;
            if (data.birthday_month < 1997) {
                birthday_month = 1997;
            } else if (data.birthday_month > 2007) {
                birthday_month = 2007;
            } else {
                birthday_month = data.birthday_month;
            }

            form.find('select[name="class_id"] option:last').prop('selected', true);
            form.find('input[name="name"]').val(data.name_sei + data.name_mei);
            form.find('input[name="name_kana"]').val(data.kana_sei + data.kana_mei);
            form.find('select[name="grade"]').val(grade);
            form.find('select[name="birthday[year]"]').val(birthday_month);
            form.find('select[name="birthday[month]"]').val(data.birthday_month);
            form.find('select[name="birthday[day]"]').val(data.birthday_day);
            form.find('input[name="email"]').val(data.email);
            form.find('input[name="tel[]"]:eq(0)').val(data.tels[0]);
            form.find('input[name="tel[]"]:eq(1)').val(data.tels[1]);
            form.find('input[name="tel[]"]:eq(2)').val(data.tels[2]);
            form.find('textarea[name="memo"]').val('これは自動登録のテストです。');
            form.find('input[type="submit"]').click();
        });
    },
    // スクリーンショット撮影後、管理者用ページからログアウト
    function() {
        test.saveScreenshot('member_create_' + test.date + test.time + '.png', function() {
            $('a:contains("ログアウト")')[0].click();
        });
    },
    // 初期ページに戻る
    function() {
        $('a:contains("教室一覧")')[0].click();
    }
];
