<?php

/**
 * 公開期間を設定
 *
 * @param string $id
 * @param array  $open
 * @param array  $close
 * @param array  $allowed
 * @param array  $denied
 *
 * @return void
 */
function service_status_set($id, $open = null, $close = null, $allowed = array(), $denied = array())
{
    if (empty($open) && empty($close)) {
        error('「' . $id . '」に対する公開開始日時、もしくは公開終了日時を指定してください。');
    } elseif (isset($GLOBALS['__status'][$id])) {
        error('「' . $id . '」に対する公開期間は、すでに設定されています。');
    }

    $GLOBALS['__status'][$id] = array(
        'open'    => $open,
        'close'   => $close,
        'allowed' => $allowed,
        'denied'  => $denied,
    );

    return;
}

/**
 * 公開設定を取得
 *
 * @param string $id
 *
 * @return bool|void
 */
function service_status_get($id)
{
    static $flag = false;

    if ($flag === false && isset($_GET['__status'])) {
        if (preg_match('/^(\d\d\d\d)(\d\d)(\d\d)(\d\d)(\d\d)$/', $_GET['__status'], $matches)) {
            $_SESSION['__status'] = sprintf('%04d-%02d-%02d %02d:%02d', $matches[1], $matches[2], $matches[3], $matches[4], $matches[5]);
        } else {
            $_SESSION['__status'] = null;
        }

        $flag = true;
    }

    if (empty($_SESSION['__status'])) {
        $now = null;
    } else {
        $now = $_SESSION['__status'];
    }

    if (in_array(clientip(), $GLOBALS['__status'][$id]['denied'])) {
        return false;
    } elseif (in_array(clientip(), $GLOBALS['__status'][$id]['allowed'])) {
        return true;
    }

    if (isset($GLOBALS['__status'][$id]['open']) && isset($GLOBALS['__status'][$id]['close'])) {
        if (localdate(null, $now) >= strtotime($GLOBALS['__status'][$id]['open']) && localdate(null, $now) <= strtotime($GLOBALS['__status'][$id]['close'])) {
            return true;
        } else {
            return false;
        }
    } elseif (isset($GLOBALS['__status'][$id]['open'])) {
        if (localdate(null, $now) >= strtotime($GLOBALS['__status'][$id]['open'])) {
            return true;
        } else {
            return false;
        }
    } elseif (isset($GLOBALS['__status'][$id]['close'])) {
        if (localdate(null, $now) <= strtotime($GLOBALS['__status'][$id]['close'])) {
            return true;
        } else {
            return false;
        }
    } else {
        error('「' . $id . '」に対する公開期間は設定されていません。');
    }
}
